% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_reduced_dim_scExp}
\alias{plot_reduced_dim_scExp}
\title{Plot reduced dimensions (PCA, TSNE, UMAP)}
\usage{
plot_reduced_dim_scExp(
  scExp,
  color_by = "sample_id",
  reduced_dim = c("PCA", "TSNE", "UMAP"),
  select_x = NULL,
  select_y = NULL,
  downsample = 5000,
  transparency = 0.6,
  size = 1,
  max_distanceToTSS = 1000,
  annotate_clusters = "cell_cluster" \%in\% colnames(colData(scExp)),
  min_quantile = 0.01,
  max_quantile = 0.99
)
}
\arguments{
\item{scExp}{A SingleCellExperiment Object}

\item{color_by}{Character of eature used for coloration. Can be cell
metadata ('total_counts', 'sample_id', ...) or a gene name.}

\item{reduced_dim}{Reduced Dimension used for plotting}

\item{select_x}{Which variable to select for x axis}

\item{select_y}{Which variable to select for y axis}

\item{downsample}{Number of cells to downsample}

\item{transparency}{Alpha parameter, between 0 and 1}

\item{size}{Size of the points.}

\item{max_distanceToTSS}{The maximum distance to TSS to consider a gene
linked to a region. Used only if "color_by" is a gene name.}

\item{annotate_clusters}{A logical indicating if clusters should be labelled.
The 'cell_cluster' column should be present in metadata.}

\item{min_quantile}{The lower threshold to remove outlier cells,
as quantile of cell embeddings (between 0 and 0.5).}

\item{max_quantile}{The upper threshold to remove outlier cells,
as quantile of cell embeddings (between 0.5 and 1).}
}
\value{
A ggplot geom_point plot of reduced dimension 2D reprensentation
}
\description{
Plot reduced dimensions (PCA, TSNE, UMAP)
}
\examples{
data("scExp")
plot_reduced_dim_scExp(scExp, color_by = "sample_id")
plot_reduced_dim_scExp(scExp, color_by = "total_counts")
plot_reduced_dim_scExp(scExp, reduced_dim = "UMAP")
plot_reduced_dim_scExp(scExp, color_by = "CD52",  reduced_dim = "UMAP")

}
