% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{visualiseDim}
\alias{visualiseDim}
\title{visualiseDim}
\usage{
visualiseDim(
  sce,
  dimNames = NULL,
  colour_by = NULL,
  shape_by = NULL,
  data_from = c("colData", "assay", "altExp"),
  assay_name = NULL,
  altExp_name = NULL,
  altExp_assay_name = NULL,
  dim = seq_len(2)
)
}
\arguments{
\item{sce}{A singlecellexperiment object}

\item{dimNames}{indicates the name of the reduced dimension results.}

\item{colour_by}{A character indicates how the cells coloured by.
The information either stored in colData, assay, or altExp.}

\item{shape_by}{A character indicates how the cells shaped by.
The information either stored in colData, assay, or altExp.}

\item{data_from}{A character indicates where the colour by data stored}

\item{assay_name}{A character indicates the assay name of the expression}

\item{altExp_name}{A character indicates the name of alternative expression}

\item{altExp_assay_name}{A character indicates the assay name
of alternative expression}

\item{dim}{a vector of numeric with length of 2 indicates
which component is being plot}
}
\value{
A ggplot of the reduced dimension visualisation
}
\description{
A function to visualise the reduced dimension
}
\examples{
data(sce_control_subset, package = "CiteFuse")
sce_control_subset <- CiteFuse(sce_control_subset)
sce_control_subset <- reducedDimSNF(sce_control_subset,
method = "tSNE",
dimNames = "tSNE_joint")
visualiseDim(sce_control_subset, dimNames = "tSNE_joint",
colour_by = "SNF_W_clust")

}
