% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{distribution}
\alias{distribution}
\alias{distribution,ClassifyResult-method}
\title{Get Frequencies of Feature Selection or Sample-wise Predictive Performance}
\arguments{
\item{result}{An object of class \code{\link{ClassifyResult}}.}

\item{...}{Further parameters, such as \code{colour} and \code{fill}, passed
to \code{\link[ggplot2]{geom_histogram}} or
\code{\link[ggplot2]{stat_density}}, depending on the value of
\code{plotType}.}

\item{dataType}{Default: \code{"features"}. Whether to summarise sample-wise error rate (\code{"samples"}) or
the number of times or frequency a feature was selected.}

\item{plotType}{Whether to draw a probability density curve or a histogram.}

\item{summaryType}{If feature selection, whether to summarise as a proportion or count.}

\item{plot}{Whether to draw a plot of the frequency of selection or error
rate.}

\item{xMax}{Maximum data value to show in plot.}

\item{fontSizes}{A vector of length 3. The first number is the size of the
title.  The second number is the size of the axes titles. The third number
is the size of the axes values.}

\item{ordering}{Default: \code{"descending"}. A character string, either \code{"descending"} or
\code{"ascending"}, which specifies the ordering direction for sorting the summary.}
}
\value{
If \code{dataType} is "features", a vector as long as the number of
features that were chosen at least once containing the number of times the
feature was chosen in cross validations or the proportion of times chosen.
If \code{dataType} is "samples", a vector as long as the number of samples,
containing the cross-validation error rate of the sample. If \code{plot} is
\code{TRUE}, then a plot is also made on the current graphics device.
}
\description{
There are two modes. For aggregating feature selection results, the function
counts the number of times each feature was selected in all
cross-validations. For aggregating predictive results, the accuracy or C-index 
for each sample is visualised. This is useful in identifying samples that are difficult
to predict well.
}
\examples{

  #if(require(sparsediscrim))
  #{
    data(asthma)
    result <- crossValidate(measurements, classes, nRepeats = 5)
    featureDistribution <- distribution(result, "features", summaryType = "count",
                                        plotType = "histogram", binwidth = 1)
    print(head(featureDistribution))
  #}
}
\author{
Dario Strbenac
}
