% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\docType{class}
\name{characterOrNA-class}
\alias{characterOrNA-class}
\title{Class Union: characterOrNA}
\description{
This class union allows for flexibility in method signatures and slot
definitions by accepting either a character value, NULL, or a missing value.
It is particularly useful when a slot or function parameter might contain
a character string but could also be empty, unspecified, or explicitly set to NULL.
}
\details{
The characterOrNA class union includes:
\itemize{
  \item character: A standard R character string or vector
  \item NULL: Representing an empty or unset value
  \item missing: Allowing for unspecified parameters in function calls
}

This union is useful in scenarios where:
\itemize{
  \item A function might return a character result or NULL if no result is available
  \item A slot in an S4 object could contain a character value or be empty
  \item A function parameter could accept a character input, but also work with default settings if nothing is provided
}
}
\seealso{
\code{\link{setClassUnion}}, \code{\link{ClustAllObject-class}}
}
