% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\name{dataValidation}
\alias{dataValidation}
\alias{dataValidation,ClustAllObject-method}
\title{Retrieve Validation Data from ClustAllObject}
\usage{
dataValidation(Object)
}
\arguments{
\item{Object}{A \code{\link{ClustAllObject-class}} object created by
\code{\link{createClustAll}} or modified by \code{\link{addValidationData}}.}
}
\value{
A numeric vector containing the validation data (true labels) if available.
Returns NULL if no validation data has been added to the object.
}
\description{
This method extracts and returns the validation data (true labels) stored in
a ClustAllObject. These labels represent known classifications or groupings
of samples, which can be used to assess the performance of clustering results.
}
\details{
The dataValidation method provides access to the ground truth or reference
classifications for the samples in the dataset:

\enumerate{
  \item Validation Data Content:
  \itemize{
    \item Contains known classifications or groupings of samples.
    \item Typically represents biological, clinical, or other meaningful categorizations.
    \item Used as benchmarking to evaluate clustering performance.
  }

  \item Data Characteristics:
  \itemize{
    \item Returned as a numeric vector.
    \item Length matches the number of samples in the original dataset.
    \item Each element corresponds to a sample's true label or classification.
  }

  \item Availability and Source:
  \itemize{
    \item May be added during object creation via the colValidation parameter in \code{\link{createClustAll}}.
    \item Can be added later using the \code{\link{addValidationData}} function.
    \item If not available, the method returns NULL.
  }
}
}
\note{
\itemize{
  \item This method returns the data stored in the 'dataValidation' slot of the ClustAllObject.
  \item The validation data is not used in the clustering process itself; it is solely for evaluation purposes.
  \item If validation data was not provided during object creation or added later, this method will return NULL.
  \item Always check for NULL before using the returned data in calculations or visualizations.
  \item The interpretation and use of validation data depend on the specific context of your study.
}
}
\examples{
data("BreastCancerWisconsin", package = "ClustAll")
wdbc <- subset(wdbc,select=-ID)
obj_noNA <- createClustAll(data = wdbc, colValidation="Diagnosis")
dataValidation(obj_noNA)
}
\seealso{
\code{\link{createClustAll}}, \code{\link{addValidationData}},
\code{\link{validateStratification}}, \code{\link{ClustAllObject-class}}
}
