% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-CogapsResult.R
\docType{methods}
\name{plotPatternMarkers}
\alias{plotPatternMarkers}
\title{heatmap of original data clustered by pattern markers statistic}
\usage{
plotPatternMarkers(
  object,
  data,
  patternMarkers,
  patternPalette,
  sampleNames,
  samplePalette = NULL,
  heatmapCol = bluered,
  colDendrogram = TRUE,
  scale = "row",
  ...
)
}
\arguments{
\item{object}{an object of type CogapsResult}

\item{data}{the original data as a matrix}

\item{patternMarkers}{pattern markers to be plotted, as generated by the 
patternMarkers function}

\item{patternPalette}{a vector indicating what color should be used
for each pattern}

\item{sampleNames}{names of the samples to use for labeling}

\item{samplePalette}{a vector indicating what color should be used
for each sample}

\item{heatmapCol}{pallelet giving color scheme for heatmap}

\item{colDendrogram}{logical indicating whether to display sample dendrogram}

\item{scale}{character indicating if the values should be centered and scaled
in either the row direction or the column direction, or none. The
default is "row".}

\item{...}{additional graphical parameters to be passed to \code{heatmap.2}}
}
\value{
heatmap of the \code{data} values for the \code{patternMarkers}
}
\description{
heatmap of original data clustered by pattern markers statistic
}
\seealso{
\code{\link{heatmap.2}}
}
