% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MsBackendCompDb-functions.R,
%   R/MsBackendCompDb.R
\name{MsBackendCompDb}
\alias{MsBackendCompDb}
\alias{MsBackendCompDb-class}
\alias{backendInitialize,MsBackendCompDb-method}
\alias{show,MsBackendCompDb-method}
\alias{peaksData,MsBackendCompDb-method}
\alias{peaksVariables,MsBackendCompDb-method}
\alias{dataStorage,MsBackendCompDb-method}
\alias{intensity<-,MsBackendCompDb-method}
\alias{mz<-,MsBackendCompDb-method}
\alias{spectraData,MsBackendCompDb-method}
\alias{spectraNames,MsBackendCompDb-method}
\alias{spectraNames<-,MsBackendCompDb-method}
\alias{[,MsBackendCompDb,ANY-method}
\alias{extractByIndex,MsBackendCompDb,ANY-method}
\alias{$<-,MsBackendCompDb-method}
\alias{precScanNum,MsBackendCompDb-method}
\alias{tic,MsBackendCompDb-method}
\alias{backendBpparam,MsBackendCompDb-method}
\title{CompDb-based MS spectrum backend}
\usage{
MsBackendCompDb()

\S4method{backendInitialize}{MsBackendCompDb}(object, x, filter, ...)

\S4method{show}{MsBackendCompDb}(object)

\S4method{peaksData}{MsBackendCompDb}(object, columns = c("mz", "intensity"))

\S4method{peaksVariables}{MsBackendCompDb}(object)

\S4method{dataStorage}{MsBackendCompDb}(object)

\S4method{intensity}{MsBackendCompDb}(object) <- value

\S4method{mz}{MsBackendCompDb}(object) <- value

\S4method{spectraData}{MsBackendCompDb}(object, columns = spectraVariables(object))

\S4method{spectraNames}{MsBackendCompDb}(object)

\S4method{spectraNames}{MsBackendCompDb}(object) <- value

\S4method{[}{MsBackendCompDb,ANY}(x, i, j, ..., drop = FALSE)

\S4method{extractByIndex}{MsBackendCompDb,ANY}(object, i)

\S4method{$}{MsBackendCompDb}(x, name) <- value

\S4method{precScanNum}{MsBackendCompDb}(object)

\S4method{tic}{MsBackendCompDb}(object, initial = TRUE)

\S4method{backendBpparam}{MsBackendCompDb}(object, BPPARAM = bpparam())
}
\arguments{
\item{object}{an \code{MsBackendCompDb} instance.}

\item{x}{an \code{MsBackendCompDb} instance.}

\item{filter}{for \code{backendInitialize()}: optional filter expression to
specify which elements to retrieve from the database.}

\item{...}{ignored.}

\item{columns}{for \code{spectraData()}: \code{character} with names of columns/spectra
variables that should be returned. Defaults to
\code{spectraVariables(object)}. Database columns \code{"ms_level"},
\code{"precursor_mz"}, \code{"precursor_intensity"}, \code{"precursor_charge"} are
mapped to the core \code{Spectra} variables \code{msLevel}, \code{precursorMz},
\code{precursorIntensity} and \code{precursorCharge}, respectively.
For \code{peaksData}: \code{character} with the names of the peaks columns to
return. Use \code{peaksVariables} for supported values.}

\item{value}{for \verb{$<-}: the replacement values.}

\item{i}{For \code{[}: \code{integer}, \code{logical} or \code{character} to subset the object.}

\item{j}{For \code{[}: not supported.}

\item{drop}{For \code{[}: not considered.}

\item{name}{for \verb{$<-}: the name of the spectra variable to replace.}

\item{initial}{for \code{tic()}: \code{logical(1)} whether original total ion current
values should be returned or if the values should be calculated based
on the actual intensity values of each spectrum.}

\item{BPPARAM}{for \code{backendBpparam()}: \code{BiocParallel} parallel processing
setup. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for more information.}
}
\value{
See the description of the respective function.
}
\description{
The \code{MsBackendCompDb} \emph{represents} MS2 spectra data from a \code{\link[=CompDb]{CompDb()}}
object/database. The object keeps only the primary keys of the spectra,
the associated compound IDs and the precursor m/z values in memory and
has thus only a very low memory footprint. All spectra variables, including
m/z and intensity values are retrieved from the database \emph{on-demand}. By
extending the \code{\link[Spectra:MsBackendCached]{Spectra::MsBackendCached()}} class directly, \code{MsBackendCompDb}
supports adding/replacing spectra variables. These values are however only
cached within the object and not propagated (written) to the database.

It is not intended that users create or use instances of this class directly,
the \code{\link[Spectra:Spectra]{Spectra::Spectra()}} call on \code{\link[=CompDb]{CompDb()}} will return a \code{Spectra}
object that uses this backend.

The \code{MsBackendCompDb} does not support parallel processing because the
database connection stored within the object can not be used across
multiple parallel processes. The \code{backendBpparam()} method for
\code{MsBackendCompDb} thus returns always \code{SerialParam} and hence any
function that uses this method to check for parallel processing capability
of a \code{MsBackend} will by default disable parallel processing.
}
\note{
For higher performance it is suggested to change the backend of the
\code{\link[Spectra:Spectra]{Spectra::Spectra()}} object to an \code{\link[Spectra:MsBackend]{Spectra::MsBackendMemory()}} backend
with the \code{\link[Spectra:Spectra]{Spectra::setBackend()}} method of \code{Spectra} objects.
}
\section{Methods implemented for \code{MsBackendCompDb}}{


The methods listed here are implemented for the \code{MsBackendCompDb}. All other
methods are inherited directly from the parent \code{\link[Spectra:MsBackendCached]{Spectra::MsBackendCached()}}
class. See the help of \code{\link[Spectra:MsBackend]{Spectra::MsBackend()}} in the \code{Spectra} package for a
complete listing of methods.
\itemize{
\item \code{peaksData()}: gets the full list of peak matrices. Returns a \code{\link[=list]{list()}},
length equal to the number of spectra and each element being a \code{matrix}
with columns \code{"mz"} and \code{"intensity"} with the spectra's m/z and intensity
values.
\item \code{peaksVariables()}: lists the available peaks variables in the backend
(database). These can be used for parameter \code{columns} of \code{peaksData()}.
\item \verb{intensity<-}: not supported.
\item \verb{mz<-}: not supported.
\item \code{spectraData()}: returns the complete spectrum data including m/z and
intensity values as a \code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame()}}.
\item \verb{$<-}: replace or add a spectrum variable. Note that \code{mz}, \code{intensity} and
\code{spectrum_id} variables can not be replaced.
}
}

\examples{

## MsBackendCompDb are not expected to be created/instanciated by users
## directly. Users also almost never directly interact with this type of
## object, as it is intented as a pure data backend for the `Spectra` object.
## Users will thus access MS data through such `Spectra` object, which can
## be created for `CompDb` objects using the `Spectra` method (see help
## of the `CompDb` object for more information. This examples shows how
## a `MsBackendCompDb` could be created purely from an SQLite database
## with data from a CompoundDb database.

## Connect to the SQLite database of a `CompDb` distributed via this package
library(RSQLite)
library(Spectra)
cdb <- CompDb(system.file("sql/CompDb.MassBank.sql", package = "CompoundDb"))

be <- backendInitialize(MsBackendCompDb(), cdb)
be

## Accessing m/z values
mz(be)
}
\author{
Johannes Rainer
}
