% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immutable-class.R
\name{setOps-immutable}
\alias{setOps-immutable}
\alias{subset.immutable}
\alias{subset,}
\alias{[.immutable,}
\alias{[[.immutable,}
\alias{$.immutable}
\alias{[}
\alias{[.immutable}
\alias{[[}
\alias{[[.immutable}
\alias{$}
\title{Subset an immutable object, returning another immutable object.}
\usage{
subset.immutable(x, ...)

\method{[}{immutable}(x, ...)

\method{[[}{immutable}(x, ...)

\method{$}{immutable}(x, ...)
}
\arguments{
\item{x}{An R object inheriting from the "immutable" S3-class.}

\item{...}{Catch any additional parameters. Lets objects with arbitrary
dimensions be made immutable.}
}
\value{
An immutable subset of \code{x}.
}
\description{
Subset an immutable object, returning another immutable object.
}
\examples{
immut_mat <- immutable(matrix(1:100, 10, 10))
immut_mat[1:5, 1:5]

}
