% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abifToFastq.R
\name{abifToFastq}
\alias{abifToFastq}
\title{Read a file in ab1 (Sanger) format and convert to fastq}
\usage{
abifToFastq(
  seqname,
  fname,
  outfname,
  trim = TRUE,
  cutoff = 0.05,
  min_seq_len = 20,
  offset = 33,
  recall = FALSE
)
}
\arguments{
\item{seqname}{name of sequence, to appear in fastq file}

\item{fname}{filename of sequence in ab1 format}

\item{outfname}{filename to append the fastq output to}

\item{trim}{should low quality bases be trimmed from the ends?  TRUE or FALSE}

\item{cutoff}{probability cutoff}

\item{min_seq_len}{minimum number of sequenced bases required in order to trim
the read}

\item{offset}{phred offset for quality scores}

\item{recall}{Use sangerseqR to resolve the primary sequence if two sequences
are present.  May cause quality scores to be ignored. (Default: FALSE)}
}
\value{
None.  Sequences are appended to the outfname.
}
\description{
This is an R implementation of Wibowo Arindrarto's abifpy.py trimming module,
which itself implement's Richard Mott's trimming algorithm
See \url{https://github.com/bow/abifpy} for more details.
}
\details{
Requires Bioconductor package SangerseqR
}
\examples{
\donttest{
# Running this code will write the fastq file to "IM2033.fastq"
ab1_fname <- system.file("extdata", "IM2033.ab1", package = "CrispRVariants")
abifToFastq("IM2033", ab1_fname, "IM2033.fastq")
}
}
\author{
Helen Lindsay
}
