% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialisers.R
\name{readsToTarget}
\alias{readsToTarget}
\alias{readsToTarget,GAlignments,GRanges-method}
\alias{readsToTarget,GAlignmentsList,GRanges-method}
\alias{readsToTarget,character,GRanges-method}
\alias{readsToTargets}
\alias{readsToTargets,character,GRanges-method}
\alias{readsToTargets,GAlignmentsList,GRanges-method}
\title{Trims reads to a target region.}
\usage{
readsToTarget(reads, target, ...)

\S4method{readsToTarget}{GAlignments,GRanges}(
  reads,
  target,
  ...,
  reverse.complement = TRUE,
  chimeras = NULL,
  collapse.pairs = FALSE,
  use.consensus = FALSE,
  store.chimeras = FALSE,
  verbose = TRUE,
  name = NULL,
  minoverlap = NULL,
  orientation = c("target", "opposite", "positive")
)

\S4method{readsToTarget}{GAlignmentsList,GRanges}(
  reads,
  target,
  ...,
  reference = reference,
  names = NULL,
  reverse.complement = TRUE,
  target.loc = 17,
  chimeras = NULL,
  collapse.pairs = FALSE,
  use.consensus = FALSE,
  orientation = c("target", "opposite", "positive"),
  minoverlap = NULL,
  verbose = TRUE
)

\S4method{readsToTarget}{character,GRanges}(
  reads,
  target,
  ...,
  reference,
  reverse.complement = TRUE,
  target.loc = 17,
  exclude.ranges = GRanges(),
  exclude.names = NA,
  chimeras = c("count", "exclude", "ignore", "merge"),
  collapse.pairs = FALSE,
  use.consensus = FALSE,
  orientation = c("target", "opposite", "positive"),
  names = NULL,
  minoverlap = NULL,
  verbose = TRUE
)

readsToTargets(reads, targets, ...)

\S4method{readsToTargets}{character,GRanges}(
  reads,
  targets,
  ...,
  references,
  primer.ranges = NULL,
  target.loc = 17,
  reverse.complement = TRUE,
  collapse.pairs = FALSE,
  use.consensus = FALSE,
  ignore.strand = TRUE,
  names = NULL,
  bpparam = BiocParallel::SerialParam(),
  orientation = c("target", "opposite", "positive"),
  chimera.to.target = 5,
  verbose = TRUE
)

\S4method{readsToTargets}{GAlignmentsList,GRanges}(
  reads,
  targets,
  ...,
  references,
  primer.ranges = NULL,
  target.loc = 17,
  reverse.complement = TRUE,
  collapse.pairs = FALSE,
  use.consensus = FALSE,
  ignore.strand = TRUE,
  names = NULL,
  bpparam = BiocParallel::SerialParam(),
  chimera.to.target = 5,
  orientation = c("target", "opposite", "positive"),
  verbose = TRUE
)
}
\arguments{
\item{reads}{A GAlignments object, or a character vector of the filenames}

\item{target}{A GRanges object specifying the range to narrow alignments to}

\item{...}{Extra arguments for initialising CrisprSet}

\item{reverse.complement}{(Default: TRUE)  Should the alignments be
oriented to match the strand of the target? If TRUE, targets located 
strand and targets on the negative strand with respect to the 
negative strand. If FALSE, the parameter 'orientation' must be set
to determine the orientation.  
'reverse.complement' will be replaced by 'orientation' in a later release.}

\item{chimeras}{Flag to determine how chimeric reads are treated.  One of
"ignore", "exclude", and "merge".  Default "count", "merge" not implemented yet}

\item{collapse.pairs}{If reads are paired, should pairs be collapsed? 
(Default: FALSE) Note: only collapses primary alignments, 
and assumes that there is only one primary alignment per read.}

\item{use.consensus}{Take the consensus sequence for non-matching pairs? If FALSE,
the sequence of the first read is used.  Can be very slow. (Default: FALSE)}

\item{store.chimeras}{Should chimeric reads be stored?  (Default: FALSE)}

\item{verbose}{Print progress and statistics (Default: TRUE)}

\item{name}{An experiment name for the reads.  (Default: NULL)}

\item{minoverlap}{Minimum number of bases the aligned read must 
share with the target site.  If not specified, the aligned
read must completely span the target region.  (Default: NULL)}

\item{orientation}{One of "target" (reads are displayed on the same
strand as the target) "opposite" (reads are displayed on the opposite)
strand from the target or "positive" (reads are displayed on the forward
strand regardless of the strand of the target)   (Default:"target")}

\item{reference}{The reference sequence}

\item{names}{Experiment names for each bam file.  If not supplied, filenames are used.}

\item{target.loc}{The zero point for renumbering (Default: 17)}

\item{exclude.ranges}{Ranges to exclude from consideration, e.g. homologous to a pcr primer.}

\item{exclude.names}{Alignment names to exclude}

\item{targets}{A set of targets to narrow reads to}

\item{references}{A set of reference sequences matching the targets.
References for negative strand targets should be on the negative strand.}

\item{primer.ranges}{A set of GRanges, corresponding to the targets.
Read lengths are typically greater than target regions, and it can
be that reads span multiple targets.  If primer.ranges are available,
they can be used to assign such reads to the correct target.}

\item{ignore.strand}{Should strand be considered when finding overlaps?
(See \code{\link[GenomicAlignments]{findOverlaps}} )}

\item{bpparam}{A BiocParallel parameter for parallelising across reads.
Default: no parallelisation.  (See \code{\link[BiocParallel]{bpparam}})}

\item{chimera.to.target}{Number of bases that may separate a chimeric read
set from the target.loc for it to be assigned to the target. (Default: 5)}
}
\value{
(signature("GAlignments", "GRanges")) A \code{\link{CrisprRun}} object

(signature("character", "GRanges")) A \code{\link{CrisprSet}} object
}
\description{
Trims aligned reads to one or several target regions,
optionally reverse complementing the alignments.
}
\examples{
# Load the metadata table
md_fname <- system.file("extdata", "gol_F1_metadata_small.txt", package = "CrispRVariants")
md <- read.table(md_fname, sep = "\t", stringsAsFactors = FALSE)

# Get bam filenames and their full paths
bam_fnames <- sapply(md$bam.filename, function(fn){
 system.file("extdata", fn, package = "CrispRVariants")})

reference <- Biostrings::DNAString("GGTCTCTCGCAGGATGTTGCTGG")
gd <- GenomicRanges::GRanges("18", IRanges::IRanges(4647377, 4647399),
       strand = "+")

crispr_set <- readsToTarget(bam_fnames, target = gd, reference = reference,
                           names = md$experiment.name, target.loc = 17)

}
\author{
Helen Lindsay
}
