% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{variantCounts}
\alias{variantCounts}
\alias{variantCounts,CrisprSet-method}
\title{Get variant counts}
\usage{
variantCounts(obj, ...)

\S4method{variantCounts}{CrisprSet}(
  obj,
  ...,
  top.n = NULL,
  min.freq = 0,
  min.count = 1,
  include.chimeras = TRUE,
  include.nonindel = TRUE,
  result = "counts",
  filter.vars = NULL
)
}
\arguments{
\item{obj}{An object containing variant counts}

\item{...}{Additional arguments}

\item{top.n}{(Integer n) If specified, return variants ranked at least n
according to frequency across all samples (Default: 0, i.e. no cutoff)}

\item{min.freq}{(Float n%) Return variants with frequency at least n% in at
least one sample (Default: 0)}

\item{min.count}{(Integer n) Return variants with count greater than n
in at least one sample (Default: 0)}

\item{include.chimeras}{Should chimeric reads be included in the counts
table? (Default: TRUE)}

\item{include.nonindel}{Should sequences without indels be returned?
(Default:TRUE)}

\item{result}{Return variants as either counts ("counts", default) or
proportions ("proportions")}

\item{filter.vars}{Labels of variants alleles to remove (Default: NULL)}
}
\value{
A matrix of counts where rows are variants and columns are samples
}
\description{
Returns a matrix of counts where rows are sequence variants
and columns are samples
}
\examples{
data("gol_clutch1")

#Return a matrix of the 5 most frequent variants
variantCounts(gol, top.n = 5)
}
\author{
Helen Lindsay
}
