% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cytoglm.R
\name{plot.cytoglm}
\alias{plot.cytoglm}
\title{Plot bootstraped coefficients}
\usage{
\method{plot}{cytoglm}(x, order = FALSE, separate = FALSE, ...)
}
\arguments{
\item{x}{A \code{cytoglm} class}

\item{order}{Order the markers according to the mangintute of the
coefficients}

\item{separate}{create two separate \code{\link[ggplot2]{ggplot2}} objects}

\item{...}{Other parameters}
}
\value{
\code{\link[ggplot2]{ggplot2}} object
}
\description{
Plot bootstraped coefficients
}
\examples{
set.seed(23)
df <- generate_data()
protein_names <- names(df)[3:12]
df <- dplyr::mutate_at(df, protein_names, function(x) asinh(x/5))
glm_fit <- CytoGLMM::cytoglm(df,
                             protein_names = protein_names,
                             condition = "condition",
                             group = "donor",
                             num_boot = 10) # in practice >=1000
plot(glm_fit)
}
