% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistSum-class.R
\docType{class}
\name{DistSum}
\alias{DistSum}
\alias{DistSum-class}
\alias{show,DistSum-method}
\alias{DistSum,matrix-method}
\alias{DistSum,list-method}
\alias{dim,DistSum-method}
\alias{dimnames,DistSum-method}
\alias{dimnames<-,DistSum,list-method}
\alias{dimnames<-,DistSum,ANY-method}
\alias{ncol,DistSum-method}
\alias{colnames,DistSum-method}
\alias{colnames<-,DistSum-method}
\alias{nrow,DistSum-method}
\alias{rownames,DistSum-method}
\alias{rownames<-,DistSum-method}
\alias{nFeatures}
\alias{featureNames,DistSum-method}
\alias{featureNames<-,DistSum-method}
\alias{[,DistSum,ANY,ANY,ANY-method}
\alias{[,DistSum,ANY,ANY,missing-method}
\alias{[,DistSum,ANY,missing,ANY-method}
\alias{[,DistSum,ANY,missing,missing-method}
\alias{as.matrix,DistSum-method}
\alias{distByFeature}
\title{DistSum class}
\usage{
\S4method{show}{DistSum}(object)

\S4method{DistSum}{matrix}(object)

\S4method{DistSum}{list}(object)

\S4method{dim}{DistSum}(x)

\S4method{dimnames}{DistSum}(x)

\S4method{dimnames}{DistSum,list}(x) <- value

\S4method{dimnames}{DistSum,ANY}(x) <- value

\S4method{ncol}{DistSum}(x)

\S4method{colnames}{DistSum}(x)

\S4method{colnames}{DistSum}(x) <- value

\S4method{nrow}{DistSum}(x)

\S4method{rownames}{DistSum}(x)

\S4method{rownames}{DistSum}(x) <- value

nFeatures(x)

\S4method{featureNames}{DistSum}(object)

\S4method{featureNames}{DistSum}(object) <- value

\S4method{[}{DistSum,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{DistSum,ANY,ANY,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{DistSum,ANY,missing,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{DistSum,ANY,missing,missing}(x, i, j, ..., drop = TRUE)

\S4method{as.matrix}{DistSum}(x, whichFeatures = NULL)

distByFeature(distObj)
}
\arguments{
\item{object}{a \code{DistSum} object}

\item{x}{a \code{DistSum} object}

\item{value}{the new feature names to be assigned}

\item{i}{the array index}

\item{j}{the column index}

\item{...}{other arguments (not used)}

\item{drop}{not supported (set to FALSE)}

\item{whichFeatures}{either an array of feature names,
or an array of feature indices, or NULL
If NULL, the full distance (for all features) will be returned
If not NULL, \code{whichFeatures} array should not contain duplicates}

\item{distObj}{a \code{DistSum} object}
}
\value{
nothing

a data.frame, with 3 columns:
\itemize{
\item featureName : self explainatory
\item distanceContrib : unidimensional distance along the corresponding feature
\item percentage : percentage of feture distance w.r.t. full distance
}
}
\description{
Class representing pairwise distances between multiple multidimensional
distributions, when the distance is calculated as a sum of marginal
distribution distances.
}
\section{Slots}{

\describe{
\item{\code{pwDistPerFeature}}{A \code{list} of \code{matrix} objects storing the contribution
of each feature (dimension) of the multidimensional distributions
to the full pairwise distance matrix.
Note these matrices are not necessarily square symmetric matrices,
as the \code{DistSum} could be occasionally used to store a given block of
a bigger distance matrix.}
}}

\examples{

# create a dummy distance matrix 
# to do this we use `nPoints` points 
# in an euclidian space of `nFeat` dimensions
nPoints <- 5
nFeat <- 7
M <- matrix(data = rnorm(nPoints * nFeat), ncol = nFeat)
rownames(M) <- paste0("point", 1:nPoints)
colnames(M) <- paste0("feat", 1:nFeat)

DList <- lapply(colnames(M),
FUN = function(colName) {
    D <- as.matrix(dist(
        M[, colName, drop = FALSE]))
    D
})

D <- Reduce(x = DList, f = function(A, B) A + B)

names(DList) <- colnames(M)

# Example of creating of a DistSum object based on the full distance matrix
distObj1 <- DistSum(D)
show(distObj1)

# Example of creation of a DistSum object based on a list of matrices
# representing the additive contribution of each feature
distObj2 <- DistSum(DList)

show(distObj2)

# getting dimensions
myDim <- dim(distObj2) # c(nPoints, nPoints)
ncols <- ncol(distObj2) # nPoints
nrows <- nrow(distObj2) # nPoints
nFeats <- nFeatures(distObj2) # nFeat
myFeatNames <- featureNames(distObj2) # paste0("feat", 1:nFeat)
myRowNames <- rownames(distObj2) # paste0("point", 1:nPoints)
myRowNames <- colnames(distObj2) # paste0("point", 1:nPoints)

# get full distance matrix
dd <- as.matrix(distObj2)

# get partial distance matrix for feature 1
dd1 <- as.matrix(distObj2, whichFeatures = 1)

# same thing, using feature name
dd1bis <- as.matrix(distObj2, whichFeatures = "feat1")

# getting partial distance for feature 1 & 2

ddPart <- as.matrix(distObj2, whichFeatures = colnames(M)[1:2])

# getting distance by feature
DF <- distByFeature(distObj2)
}
