% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoPipelineClass.R
\docType{class}
\name{CytoPipeline-class}
\alias{CytoPipeline-class}
\alias{CytoPipeline-class,}
\alias{CytoPipelineClass}
\alias{show,CytoPipeline-method}
\alias{CytoPipeline,missing-method}
\alias{CytoPipeline,list-method}
\alias{CytoPipeline,character-method}
\alias{as.list.CytoPipeline}
\alias{experimentName}
\alias{experimentName<-}
\alias{sampleFiles}
\alias{sampleFiles<-}
\alias{pData}
\alias{pData<-}
\alias{sampleDisplayNames}
\alias{sampleNameFromDisplayName}
\title{CytoPipeline class}
\usage{
\S4method{show}{CytoPipeline}(object)

\S4method{CytoPipeline}{missing}(
  object,
  experimentName = "default_experiment",
  sampleFiles = character(),
  pData = NULL
)

\S4method{CytoPipeline}{list}(
  object,
  experimentName = "default_experiment",
  sampleFiles = character(),
  pData = NULL
)

\S4method{CytoPipeline}{character}(
  object,
  experimentName = "default_experiment",
  sampleFiles = character(),
  pData = NULL
)

\method{as.list}{CytoPipeline}(x, ...)

experimentName(x)

experimentName(x) <- value

sampleFiles(x)

sampleFiles(x) <- value

pData(x)

pData(x) <- value

sampleDisplayNames(x, sampleFiles = NULL)

sampleNameFromDisplayName(x, displayName)
}
\arguments{
\item{object}{a \code{character()} containing a JSON input}

\item{experimentName}{the experiment name}

\item{sampleFiles}{a character (e.g. sampleFileNames) or a numeric vector
(e.g. indices of sample files). If NULL, all samples will be displayed.}

\item{pData}{the pheno Data (data.frame or NULL)}

\item{x}{a \code{CytoPipeline} object}

\item{...}{additional arguments (not used here)}

\item{value}{the new value to be assigned.
the \verb{pData<-} setter is a bit more liberal than it used to be:
\enumerate{
\item It can accept new pData containing more rows than existing sample names
(the corresponding subset of pData is taken).
\item It can accept pData with row names pointing to either
sample file full paths or base file names
\item It can accept pData with no row names
provided the number of rows correspond to the number of sample files.
Row names are then set by default to sample file base names (if unique),
or sample file full paths.
}}

\item{displayName}{a character}
}
\value{
nothing

\itemize{
\item for \code{as.list.CytoPipeline}: the obtained list
}

\itemize{
\item for \code{sampleDisplayNames}: a character vector
of sample display names
}

\itemize{
\item for \code{sampleNameFromDisplayName}: the sample name corresponding
to the specified display name.
of sample display names
}
}
\description{
Class representing a flow cytometry pipeline, and composed of two processing
queues, i.e. lists of CytoProcessingStep objects :
\itemize{
\item a list of CytoProcessingStep(s) for pre-calculation of scale
transformations per channel
\item a list of CytoProcessingStep(s) for the pre-processing of flow frames
}
}
\section{Slots}{

\describe{
\item{\code{scaleTransformProcessingQueue}}{A \code{list} of
CytoProcessingStep objects containing the steps
for obtaining the scale transformations per channel}

\item{\code{flowFramesPreProcessingQueue}}{A \code{list} of
CytoProcessingStep objects containing the steps
for pre-processing of the samples flow frames}

\item{\code{experimentName}}{A \code{character} containing
the experiment (run) name}

\item{\code{sampleFiles}}{A \code{character} vector storing
all fcs files to be run into the pipeline}

\item{\code{pData}}{An optional \code{data.frame} containing
additional information for each sample file.
The \code{pData} raw names should correspond to the sample files
(using full paths or base paths).
If the \code{pData} contains a columns with name 'displayName', this will have
an impact in the \code{sampleDisplayNames()} function, i.e. sample display
names will be the one mentioned in \code{pData}, instead of typically
base file names (or larger paths if base file names are not unique)}
}}

\examples{

### *** EXAMPLE 1: building CytoPipeline step by step *** ###

rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
experimentName <- "OMIP021_PeacoQC"
sampleFiles <- file.path(rawDataDir, list.files(rawDataDir,
                                             pattern = "Donor"))
                                             
outputDir <- base::tempdir()

# main parameters : sample files and output files
pipL <- CytoPipeline(experimentName = experimentName,
                     sampleFiles = sampleFiles)

### SCALE TRANSFORMATION STEPS ###

pipL <-
    addProcessingStep(pipL,
                      whichQueue = "scale transform",
                      CytoProcessingStep(
                          name = "flowframe_read",
                          FUN = "readSampleFiles",
                          ARGS = list(
                              whichSamples = "all",
                              truncate_max_range = FALSE,
                              min.limit = NULL
                          )
                      )
    )

pipL <-
    addProcessingStep(pipL,
                      whichQueue = "scale transform",
                      CytoProcessingStep(
                          name = "remove_margins",
                          FUN = "removeMarginsPeacoQC",
                          ARGS = list()
                     )
    )

pipL <-
    addProcessingStep(pipL,
                      whichQueue = "scale transform",
                      CytoProcessingStep(
                          name = "compensate",
                          FUN = "compensateFromMatrix",
                          ARGS = list(matrixSource = "fcs")
                      )
    )

pipL <-
    addProcessingStep(pipL,
                      whichQueue = "scale transform",
                      CytoProcessingStep(
                          name = "flowframe_aggregate",
                          FUN = "aggregateAndSample",
                          ARGS = list(
                              nTotalEvents = 10000,
                              seed = 0
                          )
                      )
    )

pipL <-
    addProcessingStep(pipL,
                      whichQueue = "scale transform",
                      CytoProcessingStep(
                          name = "scale_transform_estimate",
                          FUN = "estimateScaleTransforms",
                          ARGS = list(
                              fluoMethod = "estimateLogicle",
                              scatterMethod = "linear",
                              scatterRefMarker = "BV785 - CD3"
                          )
                      )
    )

### PRE-PROCESSING STEPS ###

pipL <-
    addProcessingStep(pipL,
                      whichQueue = "pre-processing",
                      CytoProcessingStep(
                          name = "flowframe_read",
                          FUN = "readSampleFiles",
                          ARGS = list(
                              truncate_max_range = FALSE,
                              min.limit = NULL
                          )
                      )
    )

pipL <-
    addProcessingStep(pipL,
                      whichQueue = "pre-processing",
                      CytoProcessingStep(
                          name = "remove_margins",
                          FUN = "removeMarginsPeacoQC",
                          ARGS = list()
                      )
    )

pipL <-
    addProcessingStep(pipL,
                      whichQueue = "pre-processing",
                      CytoProcessingStep(
                          name = "compensate",
                          FUN = "compensateFromMatrix",
                          ARGS = list(matrixSource = "fcs")
                      )
    )

pipL <-
    addProcessingStep(
        pipL,
        whichQueue = "pre-processing",
        CytoProcessingStep(
            name = "remove_debris",
            FUN = "removeDebrisManualGate",
            ARGS = list(
                FSCChannel = "FSC-A",
                SSCChannel = "SSC-A",
                gateData =  c(73615, 110174, 213000, 201000, 126000,
                              47679, 260500, 260500, 113000, 35000)))
    )

pipL <-
    addProcessingStep(pipL,
                      whichQueue = "pre-processing",
                      CytoProcessingStep(
                          name = "remove_dead_cells",
                          FUN = "removeDeadCellsManualGate",
                          ARGS = list(
                              FSCChannel = "FSC-A",
                              LDMarker = "L/D Aqua - Viability",
                              gateData = c(0, 0, 250000, 250000,
                                           0, 650, 650, 0)
                          )
                      )
    )

pipL <-
    addProcessingStep(
        pipL,
        whichQueue = "pre-processing",
        CytoProcessingStep(
            name = "perform_QC",
            FUN = "qualityControlPeacoQC",
            ARGS = list(
                preTransform = TRUE,
                min_cells = 150, # default
                max_bins = 500, # default
                step = 500, # default,
                MAD = 6, # default
                IT_limit = 0.55, # default
                force_IT = 150, # default
                peak_removal = 0.3333, # default
                min_nr_bins_peakdetection = 10 # default
            )
        )
    )

pipL <-
    addProcessingStep(pipL,
                      whichQueue = "pre-processing",
                      CytoProcessingStep(
                          name = "transform",
                          FUN = "applyScaleTransforms",
                          ARGS = list()
                      )
    )

### *** EXAMPLE 2: building CytoPipeline from JSON file *** ###

jsonDir <- system.file("extdata", package = "CytoPipeline")
jsonPath <- file.path(jsonDir, "pipelineParams.json")

pipL2 <- CytoPipeline(jsonPath,
                      experimentName = experimentName,
                      sampleFiles = sampleFiles)

}
