% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{averageIntensities}
\alias{averageIntensities}
\title{Average protein/peptide abundances for each condition studied}
\usage{
averageIntensities(ESet_obj)
}
\arguments{
\item{ESet_obj}{ExpressionSet object containing all the data}
}
\value{
a dataframe in wide format providing (in the case of 3 or more
conditions) the means of intensities for each protein/peptide
in each condition. If there are less than 3 conditions, an error message is
returned.
}
\description{
Calculate the average of the abundances for each protein in
each condition for an ExpressionSet or MSnSet. Needs to have the array
expression data ordered in the same way as the phenotype data (columns of
the array data in the same order than the condition column in the phenotype
data).
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot[seq_len(1000)]
level <- 'protein'
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeMatrix(metacell.mask, op = ">=", th = 1)
obj <- MetaCellFiltering(obj, indices, cmd = "delete")
averageIntensities(obj$new)
}
\author{
Helene Borges
}
