% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcanoPlot.R
\name{diffAnaVolcanoplot_rCharts}
\alias{diffAnaVolcanoplot_rCharts}
\title{Volcanoplot of the differential analysis}
\usage{
diffAnaVolcanoplot_rCharts(
  df,
  threshold_pVal = 1e-60,
  threshold_logFC = 0,
  conditions = NULL,
  clickFunction = NULL,
  pal = NULL
)
}
\arguments{
\item{df}{A dataframe which contains the following slots :
x : a vector of the log(fold change) values of the differential analysis,
y : a vector of the p-value values returned by the differential analysis.
index : a vector of the rowanmes of the data.
This dataframe must has been built with the option stringsAsFactors set
to FALSE. There may be additional slots which will be used to show
informations in the tooltip. The name of these slots must begin with the
prefix "tooltip_". It will be automatically removed in the plot.}

\item{threshold_pVal}{A floating number which represents the p-value that
separates differential and non-differential data.}

\item{threshold_logFC}{A floating number which represents the log of the
Fold Change that separates differential and non-differential data.}

\item{conditions}{A list of the names of condition 1 and 2 used for the
differential analysis.}

\item{clickFunction}{A string that contains a JavaScript function used to
show info from slots in df. The variable this.index refers to the slot
named index and allows to retrieve the right row to show in the tooltip.}

\item{pal}{xxx}
}
\value{
An interactive volcanoplot
}
\description{
#' Plots an interactive volcanoplot after the differential analysis.
Typically, the log of Fold Change is represented on the X-axis and the
log10 of the p-value is drawn on the Y-axis. When the \code{threshold_pVal}
and the \code{threshold_logFC} are set, two lines are drawn respectively on
the y-axis and the X-axis to visually distinguish between differential and
non differential data. With the use of the package Highcharter, a
customizable tooltip appears when the user put the mouse's pointer over
a point of the scatter plot.
}
\examples{
library(highcharter)
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot[seq_len(100)]
level <- 'protein'
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeMatrix(metacell.mask, op = ">=", th = 1)
obj <- MetaCellFiltering(obj, indices, cmd = "delete")$new
qData <- Biobase::exprs(obj)
sTab <- Biobase::pData(obj)
data <- limmaCompleteTest(qData, sTab)
df <- data.frame(
    x = data$logFC, y = -log10(data$P_Value),
    index = as.character(rownames(obj))
)
colnames(df) <- c("x", "y", "index")
tooltipSlot <- c("Fasta_headers", "Sequence_length")
df <- cbind(df, Biobase::fData(obj)[, tooltipSlot])
colnames(df) <- gsub(".", "_", colnames(df), fixed = TRUE)
if (ncol(df) > 3) {
    colnames(df)[seq.int(from = 4, to = ncol(df))] <-
        paste("tooltip_", colnames(df)[seq.int(from = 4, to = ncol(df))],
         sep = "")
}
hc_clickFunction <- JS("function(event) {
Shiny.onInputChange('eventPointClicked',
[this.index]+'_'+ [this.series.name]);}")
cond <- c("25fmol", "10fmol")
diffAnaVolcanoplot_rCharts(df, 2.5, 1, cond, hc_clickFunction)

}
\author{
Samuel Wieczorek
}
