% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacell_Plots.R
\name{mvImage}
\alias{mvImage}
\title{Heatmap of missing values}
\usage{
mvImage(qData, conds)
}
\arguments{
\item{qData}{A dataframe that contains quantitative data.}

\item{conds}{A vector of the conditions (one condition per sample).}
}
\value{
A heatmap
}
\description{
#' Plots a heatmap of the quantitative data. Each column represent one of
the conditions in the object of class \code{MSnSet} and
the color is proportional to the mean of intensity for each line of
the dataset.
The lines have been sorted in order to vizualize easily the different
number of missing values. A white square is plotted for missing values.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
qData <- Biobase::exprs(Exp1_R25_pept)
conds <- Biobase::pData(Exp1_R25_pept)[, "Condition"]
mvImage(qData, conds)

}
\author{
Samuel Wieczorek, Thomas Burger
}
