% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readers.R
\name{.readAnnotation}
\alias{.readAnnotation}
\title{read annotation data}
\usage{
.readAnnotation(
  fname,
  uniqIds = NULL,
  asGRange = TRUE,
  checkWindowNumber = TRUE,
  start0based = TRUE,
  threads = 10
)
}
\arguments{
\item{fname}{\code{character}, file name/path}

\item{uniqIds}{\code{character vector}, filter stable and keep annotation for these unique ids}

\item{asGRange}{\code{logical}, boolean, whether to reaturn a GRange object or a data.frame
object}

\item{checkWindowNumber}{\code{logical}, check window number}

\item{start0based}{\code{logical}, TRUE (default) or FALSE. If TRUE, then the start}

\item{threads}{\code{numeric}, number of threads for fread (default: 10)
positions are considered to be 0-based}
}
\value{
data.frame or GRanges object
}
\description{
read annotation data for windows
This is an unexported lowlevel function to read annotations from a file.
The file MUST be tab separated and MUST have the following columns:\cr
 chromosome: chromosome name \cr
 unique_id: unique id of the window \cr
 begin: window start co-ordinate \cr
 end: window end co-ordinate \cr
 strand: strand \cr
 gene_id: gene id \cr
 gene_name: gene name \cr
 gene_type: gene type annotation \cr
 gene_region: gene region \cr
 Nr_of_region: number of the current region \cr
 Total_nr_of_region: total number of regions \cr
 window_number: window number \cr
}
\keyword{internal}
