% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotDMCFB-method.R
\name{plotDMCFB-method}
\alias{plotDMCFB-method}
\alias{plotDMCFB,BSDMC-method}
\alias{plotDMCFB}
\title{plotDMCFB method}
\usage{
plotDMCFB(object, region, nSplit, parList)

\S4method{plotDMCFB}{BSDMC}(object, region, nSplit, parList)
}
\arguments{
\item{object}{A \code{\link{BSDMC-class}}
object}

\item{region}{An integer vector of length two specifying which subset of the
object to be plotted}

\item{nSplit}{A integer value specifying the number of subsets must be done
for plotting the results of DMC identification}

\item{parList}{A list specifying plots parameters, see \code{\link{par}}}
}
\value{
Plot
}
\description{
Plotting the results of DMC identifation stored in
a \code{\link{BSDMC-class}} object
}
\examples{
set.seed(1980)
nr <- 1000
nc <- 4
metht <- matrix(as.integer(runif(nr * nc, 0, 100)), nr)
methc <- matrix(rbinom(n = nr * nc, c(metht), prob = runif(nr * nc)), nr, nc)
methl <- methc / metht
r1 <- GRanges(rep("chr1", nr), IRanges(1:nr, width = 1), strand = "*")
names(r1) <- 1:nr
cd1 <- DataFrame(
  Group = rep(c("G1", "G2"), each = nc / 2),
  row.names = LETTERS[1:nc]
)
OBJ1 <- cBSDMC(
  rowRanges = r1, methReads = methc, totalReads = metht,
  methLevels = methl, colData = cd1
)
OBJ2 <- findDMCFB(OBJ1,
  bwa = 10, bwb = 10, nBurn = 50, nMC = 50, nThin = 1,
  alpha = 0.05, nCores = 2, pSize = 500, sfiles = FALSE
)
plotDMCFB(OBJ2)
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
