% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{plotMethylationProfile}
\alias{plotMethylationProfile}
\title{Plot Methylation Profile}
\usage{
plotMethylationProfile(
  methylationProfiles,
  autoscale = FALSE,
  labels = NULL,
  title = "",
  col = NULL,
  pch = c(1, 0, 16, 2, 15, 17),
  lty = c(4, 1, 3, 2, 6, 5)
)
}
\arguments{
\item{methylationProfiles}{a \code{GRangesList} object. Each
\code{\link{GRanges}} object in the list is generated by calling  the
function \code{\link{computeMethylationProfile}}.}

\item{autoscale}{a \code{logical} value indicating whether the values are
autoscalled for each context or not.}

\item{labels}{a \code{vector} of \code{character} used to add a subfigure
characters to the plot. If \code{NULL} nothing is added.}

\item{title}{the plot title.}

\item{col}{a \code{character} vector with the colours. It needs to contain a
minimum of 2 colours per context. If not or if NULL, the defalut colours will
be used.}

\item{pch}{the R symbols used to plot the data.}

\item{lty}{the line types used to plot the data.}
}
\value{
Invisibly returns \code{NULL}
}
\description{
This function plots the low resolution profiles for the bisulfite sequencing
data.
}
\examples{


# load the methylation data
data(methylationDataList)

# the region where to compute the profile
region <- GRanges(seqnames = Rle("Chr3"), ranges = IRanges(1,1E6))

# compute low resolution profile in 20 Kb windows
lowResProfileWTCG <- computeMethylationProfile(methylationDataList[["WT"]],
                     region, windowSize = 20000, context = "CG")

lowResProfilsCG <- GRangesList("WT" = lowResProfileWTCG)

#plot the low resolution profile
par(mar=c(4, 4, 3, 1)+0.1)
par(mfrow=c(1,1))
plotMethylationProfile(lowResProfilsCG, autoscale = FALSE,
                       title="CG methylation on Chromosome 3",
                       col=c("#D55E00","#E69F00"),  pch = c(1,0),
                       lty = c(4,1))

\dontrun{
# compute low resolution profile in 10 Kb windows in CG context
lowResProfileWTCG <- computeMethylationProfile(methylationDataList[["WT"]],
                     region, windowSize = 10000, context = "CG")

lowResProfileMet13CG <- computeMethylationProfile(
                     methylationDataList[["met1-3"]], region,
                     windowSize = 10000, context = "CG")

lowResProfileCG <- GRangesList("WT" = lowResProfileWTCG,
                   "met1-3" = lowResProfileMet13CG)

# compute low resolution profile in 10 Kb windows in CHG context
lowResProfileWTCHG <- computeMethylationProfile(methylationDataList[["WT"]],
                     region, windowSize = 10000, context = "CHG")

lowResProfileMet13CHG <- computeMethylationProfile(
                     methylationDataList[["met1-3"]], region,
                     windowSize = 10000, context = "CHG")

lowResProfileCHG <- GRangesList("WT" = lowResProfileWTCHG,
                   "met1-3" = lowResProfileMet13CHG)

# plot the low resolution profile
par(mar=c(4, 4, 3, 1)+0.1)
par(mfrow=c(2,1))
plotMethylationProfile(lowResProfileCG, autoscale = FALSE,
                       labels = LETTERS[1],
                       title="CG methylation on Chromosome 3",
                       col=c("#D55E00","#E69F00"),  pch = c(1,0),
                       lty = c(4,1))
plotMethylationProfile(lowResProfileCHG, autoscale = FALSE,
                       labels = LETTERS[2],
                       title="CHG methylation on Chromosome 3",
                       col=c("#0072B2", "#56B4E9"),  pch = c(16,2),
                       lty = c(3,2))
}

}
\seealso{
\code{\link{plotMethylationProfileFromData}},
\code{\link{computeMethylationProfile}} and \code{\link{methylationDataList}}
}
\author{
Nicolae Radu Zabet
}
