% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_all_combinations.R
\name{get_all_combinations}
\alias{get_all_combinations}
\title{Get all compatible combinations.}
\usage{
get_all_combinations(index_df, mplex_level, platform)
}
\arguments{
\item{index_df}{A dataframe containing barcodes identifiers, corresponding
DNA sequences along with GC content and presence of homopolymers.}

\item{mplex_level}{The number at which the barcodes will be multiplexed.
Illumina recommends to not multiplex more than 96 libraries.}

\item{platform}{An integer representing the number of channels (1, 2, 4)
of the desired Illumina platform: 1 for iSeq; 2 for NextSeq, NovaSeq,
MiniSeq; 4 for HiSeq and MiSeq. 0 represents any other platform than
Illumina.}
}
\value{
A matrix containing the identifiers of compatible barcode combinations.
}
\description{
Finds the exhaustive set of compatible barcode combinations.
}
\details{
Be aware that the total number of combinations may become prohibitively 
large for large barcode sets and large multiplexing numbers.
}
\examples{
get_all_combinations(DNABarcodeCompatibility::IlluminaIndexes, 2, 4)


}
\seealso{
\code{\link{get_random_combinations}}
}
