% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomHyperArray-class.R
\docType{class}
\name{RandomHyperArray-class}
\alias{RandomHyperArray-class}
\alias{RandomHyperArraySeed-class}
\alias{RandomHyperMatrix-class}
\alias{sampleDistrParam,RandomHyperArraySeed-method}
\alias{sampleDistrFun,RandomHyperArraySeed-method}
\alias{matrixClass,RandomHyperArray-method}
\alias{RandomHyperArraySeed}
\alias{DelayedArray,RandomHyperArraySeed-method}
\alias{RandomHyperArray}
\title{DelayedArray of random hypergeometric-distributed values}
\usage{
RandomHyperArraySeed(dim, m, n, k, chunkdim = NULL, sparse = FALSE)

\S4method{DelayedArray}{RandomHyperArraySeed}(seed)

RandomHyperArray(dim, m, n, k, chunkdim = NULL, sparse = FALSE)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{m, n, k}{Numeric vector used as the argument of the same name in \code{\link{qhyper}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{sparse}{Logical scalar indicating whether the sampled array should be treated as sparse.}

\item{seed}{A RandomHyperArraySeed object.}
}
\value{
All constructors return an instance of a RandomHyperArray object,
containing random draws from a hypergeometric distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of hypergeometric-distributed values.
}
\examples{
X <- RandomHyperArraySeed(c(1e5, 1e5), m=10, n=20, k=15)
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomHyperArraySeed(c(1e5, 1e5), m=round(runif(1e5, 10, 20)), 
    n=20, k=15, sparse=TRUE)
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
m <- round(RandomUnifArray(c(1e5, 1e5), 10, 20))
X3 <- RandomHyperArraySeed(c(1e5, 1e5), m=m, n=50, k=20)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
