% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotProbe.R
\name{EpiMix_PlotProbe}
\alias{EpiMix_PlotProbe}
\title{The EpiMix_PlotProbe function}
\usage{
EpiMix_PlotProbe(
  probe.name,
  EpiMixResults,
  met.platform = "HM450",
  roadmap.epigenome.id = "E002",
  numFlankingGenes = 20,
  left.gene.margin = 10000,
  right.gene.margin = 10000,
  gene.name.pos = 2,
  gene.name.size = 0.5,
  gene.arrow.length = 0.05,
  gene.line.width = 2,
  plot.chromatin.state = TRUE,
  y.label.font = 0.8,
  y.label.margin = 0.1,
  axis.number.font = 0.5,
  chromatin.label.font = 0.7,
  chromatin.label.margin = 0.02
)
}
\arguments{
\item{probe.name}{character string indicating the CpG probe name.}

\item{EpiMixResults}{resulting list object returned from EpiMix.}

\item{met.platform}{character string indicating the type of micro-array where the DNA methylation data were collected.Can be either 'HM27', 'HM450' or 'EPIC'. Default: 'HM450'}

\item{roadmap.epigenome.id}{character string indicating the epigenome id (EID) for a reference tissue or cell type. Default: 'E002'. If the value is empty (""), no histone modifications plot will show.\
Note: Keep this value empty if using the Windows system, since this feature is not supported in Windows.}

\item{numFlankingGenes}{numeric value indicating the number of flanking genes to be plotted with the CpG probe. Default: 20 (10 gene upstream and 10 gene downstream).}

\item{left.gene.margin}{numeric value indicating the number of extra nucleotide bases to be plotted on the left side of the image. Default: 10000.}

\item{right.gene.margin}{numeric value indicating the number of extra nucleotide bases to be plotted on the right side of the image. Default: 10000.}

\item{gene.name.pos}{integer indicating the position for plotting the gene name relative to the gene structure. Should be 1 or 2 or 3 or 4, indicating bottom, left, top, and right, respectively.}

\item{gene.name.size}{numeric value indicating the font size of the gene names in pixels.}

\item{gene.arrow.length}{numeric value indicating the size of the arrow which indicates the positioning of the gene.}

\item{gene.line.width}{numeric value indicating the line width for the genes.}

\item{plot.chromatin.state}{logical indicating whether to plot the DNase-seq and histone ChIP-seq signals. Warnings: If the 'numFlankingGenes' is a larger than 15, plotting the chromatin state may flood the internal memory.}

\item{y.label.font}{font size of the y axis label.}

\item{y.label.margin}{distance between y axis label and y axis.}

\item{axis.number.font}{font size of axis ticks and numbers.}

\item{chromatin.label.font}{font size of the labels of the histone proteins.}

\item{chromatin.label.margin}{distance between the histone protein labels and axis.}
}
\value{
plot with CpG probe and nearby genes. Genes whose expression is significantly negatively associated with the methylation of the probe are shown in red, while the others are shown in black.
}
\description{
plot the genomic coordinate and the chromatin state of a specific CpG probe and the nearby genes.
}
\details{
this function requires additional dependencies: karyoploteR, TxDb.Hsapiens.UCSC.hg19.knownGene, org.Hs.eg.db

roadmap.epigenome.id: since the chromatin state is tissue or cell-type specific,
EpiMix needs to know the reference tissue or cell type in order to retrieve the proper DNase-seq and histone ChIP-seq data.
Available epigenome ids can be obtained from the Roadmap Epigenomic study (Nature, PMID: 25693563, figure 2).
They can also be retrieved from the list.epigenomes() function.
}
\examples{
\donttest{
library(karyoploteR)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(org.Hs.eg.db)
library(regioneR)

data(Sample_EpiMixResults_Regular)

# The CpG site to plot
probe.name = 'cg00374492'

# The number of adjacent genes to be plotted
numFlankingGenes = 10

# Set up the reference cell/tissue type
roadmap.epigenome.id = 'E096'

# Generate the plot
EpiMix_PlotProbe(probe.name = probe.name,
                 EpiMixResults = Sample_EpiMixResults_Regular,
                 met.platform = 'HM450',
                 roadmap.epigenome.id = roadmap.epigenome.id,
                 numFlankingGenes = numFlankingGenes)

}

}
