% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventPointer_RNASeq_IGV.R
\name{EventPointerBAM_IGV}
\alias{EventPointerBAM_IGV}
\title{EventPointer RNASeq IGV Visualization}
\usage{
EventPointerBAM_IGV(SG_RNASeq, EventsCSV, PathGTF)
}
\arguments{
\item{SG_RNASeq}{Output from EventDetection_BAM function. Contains splicing graphs components.}

\item{EventsCSV}{Path to EventsFound.txt file generated with EventDetection_BAM function}

\item{PathGTF}{Directory where to write the GTF files.}

\item{Events}{Data.frame generated by EventPointer_RNASeq with the events to be included in the GTF file.}
}
\value{
Creates paths_RNASeq.gtf file that represents the alternative splicing events.
}
\description{
Generates files to be loaded in IGV for visualization and interpretation of events
}
\examples{
\dontrun{
  data(AllEvents_RNASeq)
  data(SG_RNASeq)

   # Run EventPointer

   Dmatrix<-matrix(c(1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1),ncol=2,byrow=FALSE)
   Cmatrix<-t(t(c(0,1)))
   Events <- EventPointer_RNASeq(AllEvents_RNASeq,Dmatrix,Cmatrix,Statistic='LogFC',PSI=TRUE)

   # IGV Visualization

   EventsCSV<-paste(system.file('extdata',package='EventPointer'),'/EventsFound_RNASeq.txt',sep='')
   PathGTF<-tempdir()
   EventPointerBAM_IGV(Events,SG_RNASeq,EventsCSV,PathGTF)
   }
}
