% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxFunctions.R, R/newAuxFunctions.R
\name{InternalFunctions}
\alias{InternalFunctions}
\alias{annotateEvents}
\alias{annotateEventsMultipath}
\alias{AnnotateEvents_RNASeq}
\alias{AnnotateEvents_RNASeq_MultiPath}
\alias{AnnotateEvents_KLL}
\alias{reClassificationIntern}
\alias{ClassifyEvents}
\alias{estimateAbsoluteConc}
\alias{estimateAbsoluteConcmultipath}
\alias{findTriplets}
\alias{findTriplets2}
\alias{GetCounts}
\alias{getPathCounts}
\alias{getPathFPKMs}
\alias{GetCountsMP}
\alias{getPathCountsMP}
\alias{getPathFPKMsMP}
\alias{getEventPaths}
\alias{getEventMultiPaths}
\alias{GetIGVPaths}
\alias{getPSI}
\alias{getPSImultipath}
\alias{getPSI_RNASeq}
\alias{getCountMatrix}
\alias{estimateAbsoluteConc_boot}
\alias{estimatePSI}
\alias{calcBootstrapPSI}
\alias{getPSI_RNASeq_MultiPath}
\alias{getRandomFlow}
\alias{IHsummarization}
\alias{pdist2}
\alias{PrepareCountData}
\alias{PrepareProbes}
\alias{PrepareOutput}
\alias{SG_Info}
\alias{SG_creation}
\alias{SG_creation_RNASeq}
\alias{SG_creation_fast}
\alias{WriteGTF}
\alias{WriteGTF_RNASeq}
\alias{flat2Cdf}
\alias{uniquefast}
\alias{filterimagine}
\alias{transfromedge}
\alias{sacartranscritos}
\alias{convertToSGFeatures2}
\alias{processFeatures2}
\alias{annotate2}
\alias{annotateFeatures2}
\alias{mergeExonsTerminal2}
\alias{PrimerSequenceGeneral}
\alias{PrimerSequenceTwo}
\alias{ProbesSequence}
\alias{sort.exons}
\alias{all_simple_paths2}
\alias{callPrimer3}
\alias{callPrimer3probes}
\alias{CreateSequenceforProbe}
\alias{findPotencialExons}
\alias{fullExons}
\alias{includeaexons}
\alias{genreverse}
\alias{getDistanceseachPath}
\alias{getDominants2}
\alias{getDominantsFor}
\alias{getDominantsRev}
\alias{getExonsFullSignal}
\alias{getFinalExons}
\alias{getgeneraldata}
\alias{getrankexons}
\alias{getranksequence}
\alias{PrimerSequenceCommonFor}
\alias{PrimerSequenceCommonRev}
\alias{get_beta}
\alias{get_table}
\alias{get_YB}
\alias{getInfo}
\alias{checkContrastDesignMatrices}
\alias{mclapplyPSI_Bootstrap}
\alias{call_get_table_Bootstrap}
\alias{get_table_Bootstrap}
\alias{pvalue_incr_PSI}
\alias{calculateCorrelationTest}
\alias{\%in2\%}
\alias{callGRseq_parallel}
\alias{getpij}
\alias{speedglm.wfit2}
\alias{dgl}
\alias{fitgl}
\alias{pgl}
\alias{qdgl}
\alias{qgl}
\alias{rgl}
\alias{hyperGeometricApproach}
\alias{poissonBinomialApproach}
\alias{significanceFunction}
\alias{hyperMatrixRes}
\alias{GseaApproach}
\alias{WilcoxonApproach}
\alias{Wilcoxon.z.matrix}
\alias{MatrixRes}
\alias{myphyper}
\alias{reclasify_intern}
\alias{voomEventPointerST}
\alias{voomEventPointerBAM}
\alias{voom2}
\alias{sampleWhichCount}
\alias{listCHRFileCount}
\alias{getSGFeatureCounts}
\alias{getSGFeatureCountsTotal}
\alias{processCounts}
\alias{junctionCompatible}
\alias{filterIntrons}
\alias{dimMatrixFix}
\alias{splicesiteOverlap}
\alias{exonCompatible}
\alias{findOverlapsRanges}
\alias{modFindOverlap}
\alias{splicesiteCounts}
\alias{exonCoverage}
\alias{predictTxFeatures}
\alias{expandUnstrandedRanges}
\alias{validationParameters}
\alias{globalWhich}
\alias{sampleWhichPredict}
\alias{listCHRFilePredict}
\alias{predictTxFeaturesTotal}
\alias{predictJunctions}
\alias{readGapPair}
\alias{generateWarningMessage}
\alias{fragExonIntron}
\alias{togroup0}
\alias{constructPaired}
\alias{co2str}
\alias{predictSpliced}
\alias{extractSplicesitesFromJunctions}
\alias{predictExonsTerminal}
\alias{predictCandidatesTerminal}
\alias{predictExonsInternal}
\alias{predictCandidatesInternal}
\alias{constructGRangesFromRanges}
\alias{AnnEventsFunc}
\alias{getBamInfo}
\alias{getBamInfoPerSample}
\title{EventPointer Internal Functions}
\usage{
annotateEvents(Events, PSR_Gene, Junc_Gene, Gxx)

annotateEventsMultipath(Events, PSR_Gene, Junc_Gene, Gxx, paths)

AnnotateEvents_RNASeq(Events)

AnnotateEvents_RNASeq_MultiPath(Events, paths)

AnnotateEvents_KLL(Events, Gxx, GenI)

reClassificationIntern(SG, Event)

ClassifyEvents(SG, Events, twopaths)

estimateAbsoluteConc(Signal1, Signal2, SignalR, lambda)

estimateAbsoluteConcmultipath(datos, lambda = 0.1)

findTriplets(randSol, tol = 1e-08)

findTriplets2(Incidence, paths = 2, randSol)

GetCounts(Events, sg_txiki, type = "counts")

getPathCounts(x, readsC, widthinit)

getPathFPKMs(x, readsC, widthinit)

GetCountsMP(Events, sg_txiki, type = "counts")

getPathCountsMP(x, readsC, widthinit)

getPathFPKMsMP(x, readsC, widthinit)

getEventPaths(Events, SG)

getEventMultiPaths(Events, SG, twopaths, paths)

GetIGVPaths(EventInfo, SG_Edges)

getPSI(ExFit, lambda = 0.1)

getPSImultipath(ExFit, lambda = 0.1)

getPSI_RNASeq(Result, lambda = 0.1)

getCountMatrix(Result, modeFill = "FPKM")

estimateAbsoluteConc_boot(
  Signal1,
  Signal2,
  SignalR,
  lambda = NULL,
  l1 = 1,
  l2 = 1,
  lR = 1
)

estimatePSI(CountMatrix, l1eq, l2eq, lReq, lambda = NULL)

calcBootstrapPSI(
  rowProcess,
  PSI_boot,
  CountMatrix,
  l1eq,
  l2eq,
  lReq,
  lambda,
  nboot
)

getPSI_RNASeq_MultiPath(Result, lambda = 0.1)

getRandomFlow(Incidence, ncol = 1)

IHsummarization(Pv1, t1, Pv2, t2, coherence = "Opposite")

pdist2(X, Y)

PrepareCountData(Result)

PrepareProbes(Probes, Class)

PrepareOutput(Result, Final)

SG_Info(SG_Gene)

SG_creation(SG_Gene)

SG_creation_RNASeq(SG_Gene)

SG_creation_fast(SG_Gene)

WriteGTF(PATH, Data, Probes, Paths)

WriteGTF_RNASeq(PATH, Data, Paths)

flat2Cdf(
  file,
  chipType,
  tags = NULL,
  rows = 2560,
  cols = 2560,
  verbose = 10,
  xynames = c("X", "Y"),
  gcol = 5,
  ucol = 6,
  splitn = 4,
  col.class = c("integer", "character")[c(1, 1, 1, 2, 2, 2)],
  Directory = getwd(),
  ...
)

uniquefast(X)

filterimagine(Info, paths)

transfromedge(SG, SG_Gene)

sacartranscritos(edgetr, events)

convertToSGFeatures2(x, coerce = FALSE, merge = FALSE)

processFeatures2(features, coerce = FALSE, merge = FALSE)

annotate2(query, subject)

annotateFeatures2(query, subject)

mergeExonsTerminal2(features, min_n_sample = 1)

PrimerSequenceGeneral(
  taqman,
  FinalExons,
  generaldata,
  SG,
  Dir,
  nPrimers,
  Primer3Path = Sys.which("primer3_core"),
  maxLength,
  minsep,
  wminsep,
  valuethreePpenalty,
  wnpaths,
  qualityfilter,
  mygenomesequence
)

PrimerSequenceTwo(
  FinalExons,
  SG,
  generaldata,
  n,
  thermo.param,
  Primer3Path,
  settings,
  mygenomesequence
)

ProbesSequence(
  SG,
  FinalSeq,
  generaldata,
  Dir,
  Primer3Path = Sys.which("primer3_core"),
  nProbes,
  mygenomesequence
)

sort.exons(namesPath, decreasing = FALSE)

all_simple_paths2(wg, from, to, ...)

callPrimer3(
  seq,
  threeprimers = FALSE,
  pr,
  reverse = FALSE,
  size_range = "150-500",
  Tm = c(57, 59, 62),
  name = "Primer1",
  Primer3Path = "primer3-2.3.7/bin/primer3_core",
  thermo.param = "primer3-2.3.7/src/primer3_config/",
  sequence_target = NULL,
  settings = "primer3-2.3.7/primer3web_v4_0_0_default_settings.txt"
)

callPrimer3probes(
  seq,
  name = "Primer1",
  Primer3Path = "primer3-2.3.7/bin/primer3_core",
  thermo.param = "primer3-2.3.7/src/primer3_config/",
  sequence_target = NULL,
  settings = "primer3-2.3.7/primer3web_v4_0_0_default_settings.txt"
)

CreateSequenceforProbe(SG, Exons, FinalSeq, n, mygenomesequence)

findPotencialExons(D, namesPath, maxLength, SG, minexonlength)

fullExons(namesPath)

includeaexons(Forward)

genreverse(FinalInfo, taqman)

getDistanceseachPath(Exon1, Exon2, generaldata, distinPrimers, SG)

getDominants2(
  PrimersTwo,
  Primers1,
  commonForward,
  commonReverse,
  namesRef,
  D,
  numberOfPaths,
  nprimerstwo,
  ED,
  wNpaths = 1000,
  wP12inRef = 1000
)

getDominantsFor(
  Primers1,
  Primers2,
  commonForward,
  namesRef,
  D,
  numberOfPaths,
  Event,
  ncommonForward,
  ED,
  wNpaths = 1000,
  wP12inRef = 1000
)

getDominantsRev(
  Primers1,
  Primers2,
  commonReverse,
  namesRef,
  D,
  numberOfPaths,
  Event,
  ncommonReverse,
  ED,
  wNpaths = 1000,
  wP12inRef = 1000
)

getExonsFullSignal(namesPath, SG)

getFinalExons(
  generaldata,
  maxLength,
  nPrimerstwo,
  ncommonForward,
  ncommonReverse,
  nExons,
  minsep,
  wminsep,
  valuethreePpenalty,
  minexonlength
)

getgeneraldata(SG, Event, shortdistpenalty)

getrankexons(
  SG,
  Dominants,
  nt,
  wg,
  items,
  minsep,
  wminsep,
  valuethreePpenalty,
  D
)

getranksequence(
  taqman,
  Fdata,
  maxLength,
  minsep,
  wminsep,
  valuethreePpenalty,
  wnpaths,
  qualityfilter
)

PrimerSequenceCommonFor(
  FinalExons,
  SG,
  generaldata,
  n,
  thermo.param,
  Primer3Path,
  settings,
  mygenomesequence
)

PrimerSequenceCommonRev(
  FinalExons,
  SG,
  generaldata,
  n,
  thermo.param,
  Primer3Path,
  settings,
  mygenomesequence
)

get_beta(combboots, incrPSI_original, ncontrastes)

get_table(
  PSI_arrayP,
  nevents,
  totchunk,
  chunk,
  nsamples,
  incrPSI_original,
  V,
  nboot,
  nbootin,
  ncontrastes
)

get_YB(PSI_arrayS, l, nsamples, I, J, CTEind)

getInfo(table, ncontrast)

checkContrastDesignMatrices(C, D)

mclapplyPSI_Bootstrap(
  PSI_boots,
  Design,
  Contrast,
  cores,
  ram,
  nbootstraps,
  KallistoBootstrap,
  th,
  verbose = 0
)

call_get_table_Bootstrap(
  chunklist,
  Design,
  Contrast,
  nbootstraps,
  KallistoBootstrap,
  th,
  cores
)

get_table_Bootstrap(
  PSI_arrayP,
  Design,
  Contrast,
  nbootstraps,
  KallistoBootstrap,
  th
)

pvalue_incr_PSI(incr_PSI, th = 0, verbose = 0)

calculateCorrelationTest(A, B, method = c("pearson", "spearman"))

x \%in2\% table

callGRseq_parallel(EventsFound, SG_List, cores, typeA, nt)

getpij(A)

speedglm.wfit2(
  y,
  X,
  intercept = TRUE,
  weights = NULL,
  row.chunk = NULL,
  family = gaussian(),
  start = NULL,
  etastart = NULL,
  mustart = NULL,
  offset = NULL,
  acc = 1e-08,
  maxit = 25,
  k = 2,
  sparselim = 0.9,
  camp = 0.01,
  eigendec = TRUE,
  tol.values = 1e-07,
  tol.vectors = 1e-07,
  tol.solve = .Machine$double.eps,
  sparse = NULL,
  method = c("eigen", "Cholesky", "qr"),
  trace = FALSE,
  ...
)

dgl(x, med = 0, iqr = 1, chi = 0, xi = 0.6, maxit = 1000L)

fitgl(
  x,
  start,
  inc = FALSE,
  na.rm = FALSE,
  method = c("mle", "hist", "prob", "quant", "shape"),
  ...
)

pgl(q, med = 0, iqr = 1, chi = 0, xi = 0.6, maxit = 1000L)

qdgl(p, med = 0, iqr = 1, chi = 0, xi = 0.6)

qgl(p, med = 0, iqr = 1, chi = 0, xi = 0.6)

rgl(n, med = 0, iqr = 1, chi = 0, xi = 0.6)

callGRseq_parallel(EventsFound, SG_List, cores, typeA, nt)

getpij(A)

speedglm.wfit2(
  y,
  X,
  intercept = TRUE,
  weights = NULL,
  row.chunk = NULL,
  family = gaussian(),
  start = NULL,
  etastart = NULL,
  mustart = NULL,
  offset = NULL,
  acc = 1e-08,
  maxit = 25,
  k = 2,
  sparselim = 0.9,
  camp = 0.01,
  eigendec = TRUE,
  tol.values = 1e-07,
  tol.vectors = 1e-07,
  tol.solve = .Machine$double.eps,
  sparse = NULL,
  method = c("eigen", "Cholesky", "qr"),
  trace = FALSE,
  ...
)

hyperGeometricApproach(ExS, nSel, P_value_PSI, significance, resPred, N)

poissonBinomialApproach(ExS, nSel, P_value_PSI, significance, resPred, N)

significanceFunction(P_value_PSI, cSel, nSel, significance)

hyperMatrixRes(cSel, nSel, ExS, P_value_PSI, significance, N)

GseaApproach(P_value_PSI, ExS, significance, resPred, PSI_table = NULL)

WilcoxonApproach(
  P_value_PSI,
  ExS,
  significance,
  resPred,
  PSI_table = NULL,
  nSel,
  N
)

Wilcoxon.z.matrix(
  ExprT,
  GeneGO,
  alternative = c("two.sided", "less", "greater"),
  mu = 0,
  paired = FALSE,
  exact = NULL,
  correct = TRUE,
  conf.int = FALSE,
  conf.level = 0.95
)

MatrixRes(cSel, nSel, ExS, P_value_PSI, significance, N, nmTopEv)

myphyper(p, m, n, k, lower.tail = TRUE, log.p = FALSE)

reclasify_intern(SG, mievento, pp1, pp2, ppref)

voomEventPointerST(PSI, Design, Contrast)

voomEventPointerBAM(PSI_boots, Events, Design, Contrast)

voom2(
  counts,
  design = NULL,
  lib.size = NULL,
  normalize.method = "none",
  block = NULL,
  correlation = NULL,
  weights = NULL,
  span = 0.5,
  plot = FALSE,
  save.plot = FALSE,
  keepMax = TRUE
)

sampleWhichCount(sample_info, list_features)

listCHRFileCount(which, valSample, list_features)

getSGFeatureCounts(
  sample_info,
  features,
  min_anchor = 6,
  counts_only = FALSE,
  retain_coverage = FALSE,
  verbose = FALSE,
  cores = 1
)

getSGFeatureCountsTotal(mainCount, min_anchor, retain_coverage, verbose)

processCounts(
  gap,
  features,
  strand,
  sample_name,
  min_anchor,
  retain_coverage,
  verbose
)

junctionCompatible(
  junctions,
  frag_exonic,
  frag_intron,
  min_anchor,
  counts = TRUE
)

filterIntrons(frag_intron, frag_exonic, min_anchor)

dimMatrixFix(matrix1, matrix2)

splicesiteOverlap(
  splicesites,
  side,
  frag_exonic,
  frag_intron,
  min_anchor,
  include = c("all", "spliced", "unspliced"),
  counts = TRUE
)

exonCompatible(
  exons,
  spliceL,
  spliceR,
  frag_exonic,
  frag_intron,
  counts = TRUE
)

findOverlapsRanges(query, subject, type = "any", out = "list")

modFindOverlap(
  query_unlisted,
  subject_unlisted,
  subject_togroup,
  lenQuery,
  lenSubject,
  out
)

splicesiteCounts(
  x,
  frag_exonic,
  frag_intron,
  min_anchor,
  option = c("junction", "exon"),
  include
)

exonCoverage(exons, exons_i_frag, frag_exonic)

predictTxFeatures(
  sample_info,
  which = NULL,
  alpha = 2,
  psi = 0,
  beta = 0.2,
  gamma = 0.2,
  include_counts = FALSE,
  retain_coverage = FALSE,
  junctions_only = FALSE,
  min_junction_count = NULL,
  min_anchor = 6,
  max_complexity = 20,
  min_n_sample = 1,
  min_overhang = NA,
  verbose = FALSE,
  cores = 1
)

expandUnstrandedRanges(x)

validationParameters(sample_info, alpha, min_junction_count, which)

globalWhich(sample_info)

sampleWhichPredict(sample_info, alpha, min_junction_count, which, novo)

listCHRFilePredict(range, valSample, bam_index)

predictTxFeaturesTotal(
  sWhich,
  file_bam,
  paired_end,
  which,
  min_junction_count,
  psi,
  beta,
  gamma,
  min_anchor,
  include_counts,
  retain_coverage,
  junctions_only,
  max_complexity,
  sample_name,
  verbose
)

predictJunctions(
  frag_exonic,
  frag_intron,
  min_junction_count,
  psi,
  min_anchor,
  retain_coverage
)

readGapPair(file, paired_end, which, sample_name, verbose)

generateWarningMessage(fun_name, item, msg)

fragExonIntron(gap, strand, verbose)

togroup0(x)

constructPaired(
  frag_exonic,
  frag_intron,
  junctions_df,
  min_junction_count,
  psi,
  beta,
  gamma,
  min_anchor,
  include_counts,
  retain_coverage,
  junctions_only,
  max_complexity,
  sample_name,
  seqlevel,
  strand,
  si
)

co2str(seqlevel, start, end, strand)

predictSpliced(
  frag_exonic,
  frag_intron,
  junctions_df,
  min_junction_count,
  psi,
  beta,
  gamma,
  min_anchor,
  include_counts,
  retain_coverage,
  junctions_only,
  max_complexity,
  sample_name,
  seqlevel,
  strand
)

extractSplicesitesFromJunctions(junctions, type = c("L", "R"))

predictExonsTerminal(
  candidates,
  frag_exonic,
  frag_intron,
  relCov,
  min_anchor,
  type = c("exon_L", "exon_R"),
  include_counts,
  retain_coverage
)

predictCandidatesTerminal(islands, splicesites, type = c("exon_L", "exon_R"))

predictExonsInternal(
  candidates,
  frag_exonic,
  frag_intron,
  relCov,
  min_anchor,
  include_counts,
  retain_coverage
)

predictCandidatesInternal(islands, splicesites, frag_coverage, relCov)

constructGRangesFromRanges(x, seqname, strand, seqinfo)

AnnEventsFunc(EventsDetection_pred, EventsDetection_ann, cores)

getBamInfo(PathSamplesAbundance, region, cores = 1)

getBamInfoPerSample(sample_info, region)
}
\value{
Internal outputs
}
\description{
Internal functions used by EventPointer
 in the different steps of the algorithm
}
\keyword{internal}
