% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{random_seq}
\alias{random_seq}
\title{Create random sequences}
\usage{
random_seq(
  slength,
  swidth,
  nuc = c("DNA", "RNA"),
  prob = c(0.25, 0.25, 0.25, 0.25)
)
}
\arguments{
\item{slength}{Number of sequences}

\item{swidth}{Width of the sequences}

\item{nuc}{Create sequences of DNA (nucleotides = c('A', 'C', 'G', 'T')) or
RNA (nucleotides = c('A, 'C', 'G', 'U'))?. Default: 'DNA'}

\item{prob}{A vector of four probability values used 
to set the frequency of the nucleotides 'A', 'C', 'G', 'T', for DNA,
or 'A', 'C', 'G', 'U', for RNA. For example = c(0.25, 0.25, 0.5, 0).
Default is = c(0.25, 0.25, 0.25, 0.25) (equiprobability for the 4 bases).
If the sum of the probabilities is > 1, the values will be nomalized 
to the range [0, 1].}
}
\value{
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}} object
}
\description{
Create a
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}} object
with random sequences
}
\examples{

# For reproducible examples, make a call to set.seed before 
# running each random function

set.seed(10)
s1 <- random_seq(slength = 10, swidth = 20)
s1

set.seed(10)
s2 <- random_seq(slength = 10, swidth = 20, 
prob = c(0.6, 0.1, 0.3, 0))
s2

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
