% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotSelectedFeatures}
\alias{plotSelectedFeatures}
\title{plotSelectedFeatures}
\usage{
plotSelectedFeatures(res, n_features = NULL, assay = "selected")
}
\arguments{
\item{res}{result \code{SummarizedExperiment} from \code{FeatSeek} function}

\item{n_features}{top \code{n_features} to plot. if \code{NULL} then the 
maximum number of features in res will be plotted}

\item{assay}{assay slot to plot from result \code{SummarizedExperiment} 
object, default is the selected features slot}
}
\value{
returns heatmap of selected features
}
\description{
plot correlation matrix of selected feature sets
}
\examples{
# run FeatSeek to select the top 20 features
data <-  array(rnorm(100*30), dim=c(30,100),
            dimnames = list(paste("feature", seq_len(30)), NULL))
conds <- rep(seq_len(50), 2)
res <- FeatSeek(data, conds, max_features=20)

# res stores the 20 selected features ranked by their replicate 
# reproducibility
# plot the top 5 features
plotSelectedFeatures(res, n_features=5)

}
