% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_buildSOM.R
\name{BuildSOM}
\alias{BuildSOM}
\title{Build a self-organizing map}
\usage{
BuildSOM(fsom, colsToUse = NULL, silent = FALSE, outlierMAD = 4, ...)
}
\arguments{
\item{fsom}{FlowSOM object containing the data, as constructed by 
the \code{\link{ReadInput}} function}

\item{colsToUse}{Markers, channels or indices to use for building the SOM}

\item{silent}{if \code{TRUE}, no progress updates will be printed}

\item{outlierMAD}{Number of MAD when a cell is considered an outlier.
See also \code{\link{TestOutliers}}}

\item{...}{options to pass on to the SOM function (xdim, ydim, rlen, 
mst, alpha, radius, init, distf, importance)}
}
\value{
FlowSOM object containing the SOM result, which can be used as input
        for the \code{\link{BuildMST}} function
}
\description{
Build a SOM based on the data contained in the FlowSOM object
}
\examples{

# Read from file
fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
flowSOM.res <- ReadInput(fileName, compensate = TRUE, transform = TRUE,
                         scale = TRUE)

# Build the Self-Organizing Map
# E.g. with gridsize 5x5, presenting the dataset 20 times, 
# no use of MST in neighborhood calculations in between
flowSOM.res <- BuildSOM(flowSOM.res, colsToUse = c(9, 12, 14:18),
                        xdim = 5, ydim = 5, rlen = 20)

# Build the minimal spanning tree and apply metaclustering
flowSOM.res <- BuildMST(flowSOM.res)
metacl <- MetaClustering(flowSOM.res$map$codes,
                         "metaClustering_consensus", max = 10)

}
\references{
This code is strongly based on the \code{kohonen} package.
            R. Wehrens and L.M.C. Buydens, Self- and Super-organising Maps 
            in R: the kohonen package J. Stat. Softw., 21(5), 2007
}
\seealso{
\code{\link{ReadInput}}, \code{\link{BuildMST}}
}
