% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_metaClustering.R
\name{GetMetaclusterMFIs}
\alias{GetMetaclusterMFIs}
\title{GetMetaclusterMFIs}
\usage{
GetMetaclusterMFIs(fsom, colsUsed = FALSE, prettyColnames = FALSE)
}
\arguments{
\item{fsom}{Result of calling the FlowSOM function}

\item{colsUsed}{Logical. Should report only the columns used to 
build the SOM. Default = FALSE.}

\item{prettyColnames}{Logical. Should report pretty column names instead
of standard column names. Default = FALSE.}
}
\value{
Metacluster MFIs
}
\description{
Compute the median fluorescence intensities for the metaclusters
}
\examples{
fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
ff <- flowCore::read.FCS(fileName)
ff <- flowCore::compensate(ff, flowCore::keyword(ff)[["SPILL"]])
ff <- flowCore::transform(ff,
         flowCore::transformList(colnames(flowCore::keyword(ff)[["SPILL"]]),
                                flowCore::logicleTransform()))
flowSOM.res <- FlowSOM(ff,
                       scale = TRUE,
                       colsToUse = c(9, 12, 14:18),
                       nClus = 10)
mfis <- GetMetaclusterMFIs(flowSOM.res)
}
