% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreFunctions.R
\name{runFuseSOM}
\alias{runFuseSOM}
\title{A wrapper function to run the FuseSOM algorithm}
\usage{
runFuseSOM(
  data,
  markers = NULL,
  numClusters = NULL,
  assay = NULL,
  clusterCol = "clusters",
  size = NULL,
  verbose = FALSE
)
}
\arguments{
\item{data}{a matrix, dataframe, SingleCellExperiment or SpatialExperiment
object.}

\item{markers}{the markers of interest. If this is not provided, all columns
will be used}

\item{numClusters}{the number of clusters to be generated from the data}

\item{assay}{the assay of interest if SingleCellExperiment object is used}

\item{clusterCol}{the name of the column to store the clusters in}

\item{size}{the size of the square grid. eg for a 10X10 grid, size = 10}

\item{verbose}{should the generation of the Self Organising Map be printed}
}
\value{
A list containing the SOM model and the cluster labels if a dataframe
or matrix is provided

A SingleCellExperiment object with labels in coldata, and SOM model
in metadata if a SingleCellExperiment or SpatialExperiment object is provided
}
\description{
This function accepts a matrix, dataframe or a SingleCellExperiment object.
For matrices and dataframes, it is assumed that markers are the columns and
samples rows.
}
\examples{
data("risom_dat")
risomMarkers <- c(
  "CD45", "SMA", "CK7", "CK5", "VIM", "CD31", "PanKRT", "ECAD"
)
res <- runFuseSOM(
  risom_dat,
  markers = risomMarkers, numClusters = 23, size = 8
)

}
\author{
Elijah WIllie \href{mailto:ewil3501@uni.sydney.edu.au}{ewil3501@uni.sydney.edu.au}
}
