% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G4HunterScore.R
\name{G4HunterScore}
\alias{G4HunterScore}
\title{Calculate the G4Hunter Score for a Given Sequence}
\usage{
G4HunterScore(seq = NULL)
}
\arguments{
\item{seq}{A single character string representing the nucleotide sequence.
Must contain only the characters \code{A}, \code{T}, \code{C}, \code{G},
\code{U}, and \code{N}.
The length of the sequence should not be too short (e.g., less than 10 bp).}
}
\value{
A numeric value representing the G4Hunter score for the provided
sequence.
}
\description{
This function calculates the G4Hunter score for a given nucleotide sequence,
which reflects the ability of that sequence to form a G4 structure.
}
\examples{

sequence <- "GGGTAAGGGATGGGTCGGG"
score <- G4HunterScore(sequence)
print(score)
# A negative value indicates that the G4 sequence
# is located on the reverse strand
sequence <- "GGGTAAGGGATGGGTCGGG"
score <- G4HunterScore(sequence)
print(score)
}
\seealso{
\code{\link{G4HunterDetect}} for detecting the G4 sequences in a
given \code{DNAStringSet} object.
}
