% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSNVImpact.R
\name{plotImpactSeq}
\alias{plotImpactSeq}
\title{Visualize the variants in G4 sequence}
\usage{
plotImpactSeq(filtered_gr, ncol = 1)
}
\arguments{
\item{filtered_gr}{A \code{GRanges} object containing sequence data and
G4Hunter scores. The object must have metadata columns named
\code{G4.info.score}, \code{mut.score}, \code{G4.info.sequence}, and
\code{mut.G4.seq}.}

\item{ncol}{An integer specifying the number of columns in the output plot
grid. Default is 1.}
}
\value{
A plot that displays the grid of sequence logos, showing the
differences between the original and mutated sequences.
}
\description{
This function is deprecated and will be removed in a future version.
}
\details{
This function plot sequence logos to visualize sequence variants caused by
SNVs or SNPs, with the location of the variants highlighted by rectangles
and arrows.
}
\section{Deprecated}{

This function is no longer supported.
Use \code{\link{plotImpactedG4}} instead.
}

\examples{

if (!requireNamespace("GenomicRanges", quietly = TRUE)) {
  BiocManager::install("GenomicRanges")
}

library(GenomicRanges)

seq <- data.frame(chr = c("seq1", "seq2"),
                  seq = c("ATTTGGGAGGGAGGGAGGGATGATGAAAATTTTATTTATTTTATTTA",
                          "TTTATACTATTCCCTTACCCTCCCATCCCCATACGGCATCTAGATC"))
seq_gr <- loadSequence(seq)
G4 <- G4HunterDetect(seq_gr)

snv_gr <- GRanges(seqnames = c("seq1", "seq2"),
                  ranges = IRanges(start = c(18, 23), width = 1),
                  ref = c("G", "C"),
                  alt = c("C", "G"))

effect <- SNVImpactG4(G4, snv_gr, alt_col = "alt")
plotImpactSeq(effect, ncol = 2)
}
\seealso{
\code{\link{SNVImpactG4}} for evaluating the impact of SNVs on G4
formation, and \code{\link{filterSNVImpact}} for filtering G4s that are
significantly affected by SNVs.
}
