% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HGVSnames.R
\name{HGVSnames}
\alias{HGVSnames}
\title{Generate genomic variant data to HGVS nomenclature}
\usage{
HGVSnames(start, ref, alt, type = "g", seqnames = NA_character_)
}
\arguments{
\item{start}{genomic location of start}

\item{ref}{reference sequence}

\item{alt}{alternate sequence}

\item{type}{Sequence type to be used as prefix. Allowed options are:
\itemize{
  \item \code{g} genomic (default);
  \item \code{m} mitochondrial;
  \item \code{c} coding DNA;
  \item \code{n} non-coding DNA.
}}

\item{seqnames}{name of sequence (e.g. chr1, 1). It is optional.}
}
\value{
Genomic coordinates of variants formatted as HGVS nomenclature.
}
\description{
This function follows the official reference HGVS nomenclature.
At this moment, it supports only 'substitution' and 'indel' for DNA sequences.
}
\examples{
start <- c(45576, "88+1", 6775, 6775, 145, 9002, 4, 12345611, 58347698)
ref <- c("A", "G", "T", "TCA", "CGA", "AAAAAAAA", "GC", "G", "A")
alt <- c("C", "T", "GA", "C", "TGG", "TTT", "TG", "A", "*")
type <- c("g", "c", "g", "g", "c", "g", "g", "g", "g")
seqnames <- c("", "", NA, NA, NA, NA, NA, "chr11", NA)
HGVSnames(start, ref, alt, type, seqnames)
}
\references{
\href{http://varnomen.hgvs.org/}{Sequence Variant Nomenclature}.
}
