% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDataset.R
\name{getDataset}
\alias{getDataset}
\title{getDataset function}
\usage{
getDataset(host, datasetId)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{datasetId}{The ID of the dataset to be retrieved.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Get a dataset by its ID.
}
\details{
This function requests \code{GET host/datasets/datasetId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
getDataset(host, datasetId)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/metadata_service.proto.html#GetDataset}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchDatasets}}
}
