% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getReference.R
\name{getReference}
\alias{getReference}
\title{getReference function}
\usage{
getReference(host, referenceId)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{referenceId}{The ID of the Reference to be retrieved.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Get a reference by its ID.
}
\details{
This function requests \code{GET host/references/referenceId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
referenceSetId <- searchReferenceSets(host, nrows = 1)$id
referenceId <- searchReferences(host, referenceSetId, nrows = 1)$id
getReference(host, referenceId)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/reference_service.proto.html#GetReference}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchReferences}}
}
