% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listReferenceBases.R
\name{listReferenceBases}
\alias{listReferenceBases}
\title{listReferenceBases function}
\usage{
listReferenceBases(host, referenceId, start = 1, end = NA_integer_)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{referenceId}{The ID of the Reference to be retrieved.}

\item{start}{The start position (1-based) of this query. Defaults to 0.
Genomic positions are non-negative integers less than reference length.
Requests spanning the join of circular genomes are represented as two
requests one on each side of the join (position 1).}

\item{end}{The end position (1-based, inclusive) of this query.
Defaults to the length of this Reference.}
}
\value{
\code{\link{BString}} object.
}
\description{
Get the sequence bases of a reference genome by genomic range.
}
\details{
This function requests \code{POST host/listreferencebases}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
referenceSetId <- searchReferenceSets(host, nrows = 1)$id
referenceId <- searchReferences(host, referenceSetId, nrows = 1)$id
listReferenceBases(host, referenceId, start = 1, end = 100)
}
}
\seealso{
\code{\link{searchReferenceSets}}, \code{\link{searchReferences}}
}
