% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchVariantAnnotationSets.R
\name{searchVariantAnnotationSets}
\alias{searchVariantAnnotationSets}
\title{searchVariantAnnotationSets function}
\usage{
searchVariantAnnotationSets(host, variantSetId, nrows = Inf,
  responseSize = NA_integer_)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{variantSetId}{Required. The VariantSet to search.}

\item{nrows}{Number of rows of the data frame returned by this function.
If not defined, the function will return all entries. If the number of
available entries is less than the value of this this parameter, the function
will silently return only the available entries.}

\item{responseSize}{Specifies the number of entries to be returned by the
server until reach the number of rows defined in \code{nrows} parameter or
until get all available entries. If not defined, the server will return the
allowed maximum reponse size. Increasing this the value of this parameter will
reduce the number of requests and reducing the time required. The will not
respect this parameter if the value if larger than its maximum response size.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Search for variant annotation sets (annotated VCF files).
}
\details{
This function maps to \code{POST host/variantannotationsets/search}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
variantSetId <- searchVariantSets(host, datasetId, nrows = 2)$id[2]
searchVariantAnnotationSets(host, variantSetId)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/allele_annotation_service.proto.html#SearchVariantAnnotationSets}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}
}
