% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchVariants.R
\name{searchVariants}
\alias{searchVariants}
\title{searchVariants function}
\usage{
searchVariants(host, variantSetId, referenceName, start, end,
  callSetIds = character(), nrows = Inf, responseSize = NA_integer_,
  asVCF = TRUE)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{variantSetId}{The variant set to search.}

\item{referenceName}{Required. Only return variants on this reference.}

\item{start}{Required. The beginning of the window (1-based, inclusive) for
which overlapping variants should be returned. Genomic positions are
non-negative integers less than reference length. Requests spanning the join
of circular genomes are represented as two requests one on each side of the
join (position 1).}

\item{end}{Required. The end of the window (1-based, inclusive) for which
overlapping variants should be returned.}

\item{callSetIds}{Only return variant calls which belong to callsets with
these IDs. If unspecified, return all variants and no variant call objects.}

\item{nrows}{Number of rows of the data frame returned by this function.
If not defined, the function will return all entries. If the number of
available entries is less than the value of this this parameter, the function
will silently return only the available entries.}

\item{responseSize}{Specifies the number of entries to be returned by the
server until reach the number of rows defined in \code{nrows} parameter or
until get all available entries. If not defined, the server will return the
allowed maximum reponse size. Increasing this the value of this parameter will
reduce the number of requests and reducing the time required. The will not
respect this parameter if the value if larger than its maximum response size.}

\item{asVCF}{If \code{TRUE} the function will return an \code{\link{VCF}}
with header (default), otherwise it will return an
\code{DataFrame}.}
}
\value{
\code{\link{VCF}} object (when \code{asVCF = TRUE}) or
\code{\link{DataFrame}} object (otherwise).
}
\description{
Search for variants by genomic ranges (lines of VCF files).
}
\details{
This function maps to \code{POST host/variants/search}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
variantSetId <- searchVariantSets(host, datasetId, nrows = 1)$id
searchVariants(host, variantSetId, referenceName = "1",
    start = 15000, end = 16000)

searchVariants(host, variantSetId, referenceName = "1",
    start = 15000, end = 16000, asVCF = FALSE)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/variant_service.proto.html#SearchVariants}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{getVariant}},
\code{\link{searchVariantsByGRanges}}, \code{\link{VCF}},
\code{\link{makeVCFFromGA4GHResponse}}
}
