% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GARS_crossover.R
\name{GARS_Crossover}
\alias{GARS_Crossover}
\title{Perform the one-point and the two-point Crossover}
\usage{
GARS_Crossover(chr.pop, co.rate = 0.8, type = c("one.p", "two.p"),
  one.p.quart = c("I.quart", "II.quart", "III.quart"))
}
\arguments{
\item{chr.pop}{A matrix or a data.frame representing the chromosomes
population: each column is a chromosome and each element corresponds
 to the feature position in the data matrix}

\item{co.rate}{The probability of each random couple of chromosomes
to swap some parts. It must be between 0 and 1. Default is 0.8}

\item{type}{The type of crossover method; one-point ("one.p")
and two-point ("two.p") are allowed. Default is "one.p"}

\item{one.p.quart}{The position of the cromosome where performing
the crossover, if "one.p" is selected. The first quartile
 ("I.quart"), the second quartile ("II.quart", i.e. the median)
  and the third quartile ("III.quart") are allowed. Default is "I.quart"}
}
\value{
A matrix representing the "crossed" population. The dimensions of
this matrix are the same of 'chr.pop'
}
\description{
This function implements the one-point and the two-point
 cross-over.
}
\examples{
data(GARS_popul)
crossed_pop <- GARS_Crossover(GARS_popul, co.rate=0.9)
crossed_pop <- GARS_Crossover(GARS_popul, type="two.p")
crossed_pop <- GARS_Crossover(GARS_popul, type="one.p",
one.p.quart= "II.quart")

}
\seealso{
\code{\link{GARS_Mutation}},
\code{\link{GARS_Selection}},
\code{\link{GARS_Elitism}},
}
\author{
Mattia Chiesa, Luca Piacentini
}
