% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{AR_classification_wrapper}
\alias{AR_classification_wrapper}
\title{Run the activator-repressor classification for the TFs for a \code{\linkS4class{GRN}} object}
\usage{
AR_classification_wrapper(
  GRN,
  significanceThreshold_Wilcoxon = 0.05,
  plot_minNoTFBS_heatmap = 100,
  deleteIntermediateData = TRUE,
  plotDiagnosticPlots = TRUE,
  outputFolder = NULL,
  corMethod = "pearson",
  forceRerun = FALSE
)
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{significanceThreshold_Wilcoxon}{Numeric[0,1]. Default 0.05. Significance threshold for Wilcoxon test that is run in the end for the final classification. See the Vignette and *diffTF* paper for details.}

\item{plot_minNoTFBS_heatmap}{Integer[1,]. Default 100. Minimum number of TFBS for a TF to be included in the heatmap that is part of the output of this function.}

\item{deleteIntermediateData}{\code{TRUE} or \code{FALSE}.  Default \code{TRUE}. Should intermediate data be deleted before returning the object after a successful run? Due to the size of the produced intermediate data, we recommend setting this to \code{TRUE}, but if memory or object size are not an issue, the information can also be kept.}

\item{plotDiagnosticPlots}{\code{TRUE} or \code{FALSE}. Default \code{TRUE}. Run and plot various diagnostic plots? If set to \code{TRUE}, PDF files will be produced and saved in the output directory (in a subfolder called \code{plots}).}

\item{outputFolder}{Character or \code{NULL}. Default \code{NULL}. If set to \code{NULL}, the default output folder as specified when initiating the 
object in \code{\link{initializeGRN}} will be used. Otherwise, all output from this function will be put into the specified folder. 
If a folder is provided, while we recommend specifying an absolute path, a relative one also works.}

\item{corMethod}{Character. One of \code{pearson}, \code{spearman} or \code{bicor}. Default \code{pearson}. Method for calculating the correlation coefficient. 
For \code{pearson} and \code{spearman} , see \link{cor} for details. \code{bicor} denotes the *biweight midcorrelation*, a correlation measure based on medians as
calculated by \code{WGCNA::bicorAndPvalue}. Both \code{spearman} and \code{bicor} are considered more robust measures that are less prone to be affected by outliers.}

\item{forceRerun}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Force execution, even if the GRN object already contains the result. Overwrites the old results.}
}
\value{
An updated \code{\linkS4class{GRN}} object, with additional information added from this function.
}
\description{
Run the activator-repressor classification for the TFs for a \code{\linkS4class{GRN}} object
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
# GRN = loadExampleObject()
# GRN = AR_classification_wrapper(GRN, outputFolder = ".", forceRerun = FALSE)
}
