% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{addTFBS}
\alias{addTFBS}
\title{Add TFBS to a \code{\linkS4class{GRN}} object.}
\usage{
addTFBS(
  GRN,
  source = "custom",
  motifFolder = NULL,
  TFs = "all",
  translationTable = "translationTable.csv",
  translationTable_sep = " ",
  filesTFBSPattern = "_TFBS",
  fileEnding = ".bed",
  nTFMax = NULL,
  EnsemblVersion = NULL,
  JASPAR_useSpecificTaxGroup = NULL,
  JASPAR_removeAmbiguousTFs = TRUE,
  forceRerun = FALSE,
  ...
)
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{source}{Character. One of \code{custom}, \code{JASPAR2022} or \code{JASPAR2024}. Default \code{custom}. If a custom source is being used, further details about the motif folder and files will be provided (see the other function arguments). 
If set to \code{JASPAR2022}, the \href{https://bioconductor.org/packages/release/data/annotation/html/JASPAR2022.html}{JASPAR2022} database is used.
If set to \code{JASPAR2024}, the \href{https://bioconductor.org/packages/release/data/annotation/html/JASPAR2024.html}{JASPAR2024} database is used.}

\item{motifFolder}{Character. No default. Only relevant if \code{source = "custom"}. Path to the folder that contains the TFBS predictions. The files must be in BED format, 6 columns, one file per TF. See the other parameters for more details. The folder must also contain a so-called translation table, see the argument \code{translationTable} for details.}

\item{TFs}{Character vector. Default \code{all}. Only relevant if \code{source = "custom"}. Vector of TF names to include. The special keyword \code{all} can be used to include all TF found in the folder as specified by \code{motifFolder}. If \code{all} is specified anywhere, all TFs will be included. TF names must otherwise match the file names that are found in the folder, without the file suffix.}

\item{translationTable}{Character. Default \code{translationTable.csv}. Only relevant if \code{source = "custom"}. Name of the translation table file that is also located in the folder along with the TFBS files. This file must have the following structure: at least 2 columns, called \code{ENSEMBL} and \code{ID}. \code{ID} denotes the ID for the TF that is used throughout the pipeline (e.g., AHR) and the prefix of how the corresponding file is called (e.g., \code{AHR.0.B} if the file for AHR is called \code{AHR.0.B_TFBS.bed.gz}), while \code{ENSEMBL} denotes the ENSEMBL ID (dot suffix; e.g., ENSG00000106546, are removed automatically if present).}

\item{translationTable_sep}{Character. Default \code{" "} (white space character). Only relevant if \code{source = "custom"}. The column separator for the \code{translationTable} file.}

\item{filesTFBSPattern}{Character. Default \code{"_TFBS"}. Only relevant if \code{source = "custom"}. Suffix for the file names in the TFBS folder that is not part of the TF name. Can be empty. For example, for the TF CTCF, if the file is called \code{CTCF.all.TFBS.bed}, set this parameter to \code{".all.TFBS"}.}

\item{fileEnding}{Character. Default \code{".bed"}. Only relevant if \code{source = "custom"}. File ending for the files from the motif folder.}

\item{nTFMax}{\code{NULL} or Integer[1,]. Default \code{NULL}. Maximal number of TFs to import. Can be used for testing purposes, e.g., setting to 5 only imports 5 TFs even though the whole \code{motifFolder} has many more TFs defined.}

\item{EnsemblVersion}{\code{NULL} or Character(1). Default \code{NULL}. Only relevant if \code{source} is not set to \code{custom}, ignored otherwise. The Ensembl version to use for the retrieval of gene IDs from their provided database names (e.g., JASPAR) via \code{biomaRt}.
By default (\code{NULL}), the newest version is selected for the most recent genome assembly versions is used (see \code{biomaRt::listEnsemblArchives()} for supported versions). This parameter can override this to use a custom (older) version instead.}

\item{JASPAR_useSpecificTaxGroup}{\code{NULL} or Character(1). Default \code{NULL}. Should a tax group instead of th specific genome assembly be used for retrieving the TF list? This is useful for genomes that are not human or mouse for which JASPAR otherwise returns too few TFs otherwise.
If set to \code{NULL}, the specific genome version as provided in the object is used within \code{TFBSTools::getMatrixSet} in the \code{opts} list for \code{species}, 
while \code{tax_group} will be used instead if this argument is not set to \code{NULL}. For example, it can be set to \code{vertebrates} to use the vertebrates TF collection.
For more details, see \code{?TFBSTools::getMatrixSet}.}

\item{JASPAR_removeAmbiguousTFs}{\code{TRUE} or \code{FALSE}.  Default \code{TRUE}. Remove TFs for which the name as provided b JASPAR cannot be mapped uniquely to one and only Ensembl ID? 
By default (\code{NULL}), the newest version is selected (see \code{biomaRt::listEnsemblArchives()} for supported versions). This parameter can override this to use a custom (older) version instead.}

\item{forceRerun}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Force execution, even if the GRN object already contains the result. Overwrites the old results.}

\item{...}{Additional named elements for the \code{opts} function argument from \code{?TFBSTools::getMatrixSet} that is used to query the JASPAR database.}
}
\value{
An updated \code{\linkS4class{GRN}} object, with additional information added from this function(\code{GRN@annotation$TFs} in particular)
}
\description{
For this, a folder that contains one TFBS file per TF in bed or bed.gz format must be given (see details). The folder must also contain a so-called translation table, see the argument \code{translationTable} for details. 
We provide example files for selected supported genome assemblies (hg19, hg38 and mm10, mm39) that are fully compatible with GRaNIE as separate downloads. For more information, check \url{https://difftf.readthedocs.io/en/latest/chapter2.html#dir-tfbs}.
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
}
