% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRscatter.R
\name{GRscatter}
\alias{GRscatter}
\title{Scatterplot of a given GR metric}
\usage{
GRscatter(fitData, metric, variable, xaxis, yaxis, plotly = TRUE)
}
\arguments{
\item{fitData}{a SummarizedExperiment object, generated by the GRfit 
function.}

\item{metric}{the GR metric (GR50, GRinf, h_GR, GRmax, GEC50, or GR_AOC) 
or traditional metric (IC50, Einf, h, Emax, EC50, or AUC) that will be used 
for the scatterplot.}

\item{variable}{The name of the variable from data (e.g. drug, cell-line,
etc.) to select factors from.}

\item{xaxis}{a vector of values of "variable" of data to be used for the
scatterplot's x-axis}

\item{yaxis}{a vector of values of "variable" of data to be used for the
scatterplot's y-axis}

\item{plotly}{a logical value indicating whether to output a ggplot2 graph
or a ggplotly graph}
}
\value{
a ggplot2 or ggplotly scatterplot of the x-axis variable(s) versus
the y-axis variable(s) for the given GR metric
}
\description{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function creates a scatterplot according to the parameters below.
}
\details{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function creates a scatterplot of a given GR metric (GR50, GRmax,
etc.) or traditional metric (IC50, Emax, etc.) with the "xaxis" values 
plotted against the "yaxis" values. The results can be viewed in a static 
ggplot image or an interactive plotly graph.

The xaxis and yaxis vectors must be of the same length or at least one must
be of length one. For each pair of values xaxis[i] and yaxis[i], the
function will create a scatterplot (all on one graph) of the specified GR
metric. If a vector is of length one, it will be repeated to the length of
the other vector.
}
\examples{
# Load Case A (example 1) input
data("inputCaseA")
head(inputCaseA)
# Run GRfit function with case = "A"
output1 = GRfit(inputData = inputCaseA,
groupingVariables = c('cell_line','agent', 'perturbation','replicate',
'time'))
GRscatter(output1, 'GR50', 'agent', c('drugA','drugD'), 'drugB')
GRscatter(output1, 'GR50', 'agent', c('drugA','drugD'), 'drugB',
plotly = FALSE)
}
\seealso{
To create the object needed for this function, see
\code{\link{GRfit}}. For other visualizations, see \code{\link{GRdrawDRC}}
and \code{\link{GRbox}}. For online GR calculator and browser, see
\url{http://www.grcalculator.org}.
}
\author{
Nicholas Clark
}
