% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_histogram.R
\name{buildHistogramData}
\alias{buildHistogramData}
\title{Prepare data for \code{gsHistogram()}.}
\usage{
buildHistogramData(
  genesets,
  gs_names,
  gs_description = NULL,
  start = 0,
  end = 0
)
}
\arguments{
\item{genesets}{a \code{list}, A \code{list} of genesets where each genesets is
represented by \code{list} of genes.}

\item{gs_names}{character vector, Name / identifier of the genesets in
\code{genesets}}

\item{gs_description}{Optional, a character vector containing a short
description for each geneset}

\item{start}{numeric, Optional, describes the minimum gene set size to
include. Defaults to 0.}

\item{end}{numeric, Optional, describes the maximum gene set size to include.
Defaults to 0.}
}
\value{
A \code{data.frame} mapping geneset names to sizes
}
\description{
Prepare the data for the \code{gsHistogram()} by generating a \code{data.frame}
which maps geneset names / identifiers to the size of their size.
}
\examples{
## Mock example showing how the data should look like
gs_names <- c("a", "b", "c", "d", "e", "f", "g", "h", "i")
genesets <- list(
  c("PDHB", "VARS2"), c("IARS2", "PDHA1"),
  c("AAAS", "ABCE1"), c("ABI1", "AAR2"), c("AATF", "AMFR"),
  c("BMS1", "DAP3"), c("AURKAIP1", "CHCHD1"), c("IARS2"),
  c("AHI1", "ALMS1")
)

p <- buildHistogramData(genesets, gs_names)

## Example using the data available in the package
data(macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())
genes <- GeDi::prepareGenesetData(macrophage_topGO_example_small)
p <- buildHistogramData(genes, macrophage_topGO_example_small$Genesets)
}
