% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GeneBreakMethods.R
\docType{methods}
\name{bpFilter,CopyNumberBreakPoints-method}
\alias{bpFilter}
\alias{bpFilter,CopyNumberBreakPoints-method}
\title{bpFilter}
\usage{
\S4method{bpFilter}{CopyNumberBreakPoints}(object, filter = "CNA-ass",
  threshold = NULL)
}
\arguments{
\item{object}{An object of class \linkS4class{CopyNumberBreakPoints}}

\item{filter}{Type of filter. This can be either "CNA-ass", "deltaSeg" or "deltaCall".
\itemize{
  \item CNA-ass: filter out breakpoints that are flanked by copy number neutral segments to obtain CNA-associated breakpoint locations
  \item deltaSeg: selects for breakpoints where the log2 ratio transition of the copy number segments exceeds the user-defined threshold
  \item deltaCall: selects only breakpoints of discrete copy number states (amplification, gain, neutral, loss)
}}

\item{threshold}{Set the minimal log2 ratio difference between segments. This parameter is required for the "deltaSeg" filter option}
}
\value{
Returns an object of class \linkS4class{CopyNumberBreakPoints} with breakpoint matrix replaced by filtered breakpoints.
}
\description{
Selects breakpoints by filter criteria options.
}
\details{
Filter options "CNA-ass" and "deltaCall" require calls in addition to segmented copynumber data (see input for \code{getBreakpoints()} )
}
\examples{
data( copynumber.data.chr20 )
bp <- getBreakpoints( copynumber.data.chr20 )
bp <- bpFilter( bp, filter = "CNA-ass" )
bp <- bpFilter( bp, filter = "deltaSeg", threshold = 0.2 )

## options to inspect the data
bp
accessOptions( bp )
}

