% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScorePGSEA.R
\name{ScorePGSEA}
\alias{ScorePGSEA}
\title{Compute pairwise distances between samples with method in package PGSEA}
\usage{
ScorePGSEA(
  MergingSet,
  SignatureLength,
  ScoringDistance = c("avg", "max"),
  p.value = FALSE
)
}
\arguments{
\item{MergingSet}{an \code{\link[Biobase:class.ExpressionSet]{Biobase::ExpressionSet}} object. The assay data
represents the PRLs of the samples, each column represents one PRL. The
number of sample must be greater than 1, otherwise, this function is not
meaningful.}

\item{SignatureLength}{the length of "gene signature". In order to compute
pairwise distances among samples, genes lists are ranked according to the
gene expression ratio (fold change). And the "gene signature" includes the
most up-regulated genes (near the top of the list) and the most
down-regulated genes (near the bottom of the list).}

\item{ScoringDistance}{the distance measurements between PRLs: the Average
Enrichment Score Distance ("avg"), or the Maximum Enrichment Score
Distance ("max").}

\item{p.value}{logical, if \code{TRUE} return a matrix of \code{p.values} of the
distance matrix, default \code{FALSE}.}
}
\value{
an distance-matrix, the max distance is more sensitive to weak
similarities, providing a lower precision but a larger recall.If \code{p.value}
is set to \code{TRUE}, then a list is returned that consists of the distance
matrix  as well as their p.values, otherwise, without p.values in the
result.
}
\description{
Compute pairwise distances between sample according to their
(Prototype Ranked List) PRL, get a \verb{N x N} distance matrix is generated by
calling this function , \code{N} is the length of PRL.
}
\examples{
# load the sample expressionSet
data(exampleSet)
# Merging each group of the ranked lists in the exampleSet with the same
# phenotypic data into a single PRL
MergingSet <- RankMerging(exampleSet,"Spearman")
# get the distance matrix
ds <- ScorePGSEA(MergingSet,250, ScoringDistance="avg")
}
\seealso{
\code{\link[=ScoreGSEA]{ScoreGSEA()}},\code{\link[=SignatureDistance]{SignatureDistance()}}
}
