% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhance_table.R
\name{distill_enrichment}
\alias{distill_enrichment}
\title{Distill enrichment results}
\usage{
distill_enrichment(
  res_enrich,
  res_de,
  annotation_obj,
  gtl = NULL,
  n_gs = nrow(res_enrich),
  cluster_fun = "cluster_markov"
)
}
\arguments{
\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis.}

\item{res_de}{A \code{DESeqResults} object. As for the \code{dds} parameter, this is
also commonly used in the \code{DESeq2} framework.}

\item{annotation_obj}{A \code{data.frame} object, containing two columns, \code{gene_id}
with a set of unambiguous identifiers (e.g. ENSEMBL ids) and \code{gene_name},
containing e.g. HGNC-based gene symbols.}

\item{gtl}{A \code{GeneTonic}-list object, containing in its slots the arguments
specified above: \code{dds}, \code{res_de}, \code{res_enrich}, and \code{annotation_obj} - the names
of the list \emph{must} be specified following the content they are expecting}

\item{n_gs}{Integer value, corresponding to the maximal number of gene sets to
be used.}

\item{cluster_fun}{Character, referring to the name of the function used for
the community detection in the enrichment map graph. Could be one of "cluster_markov",
"cluster_louvain", or "cluster_walktrap", as they all return a \code{communities}
object.}
}
\value{
A list containing three objects:
\itemize{
\item the distilled table of enrichment, \code{distilled_table}, where the new meta-genesets
are identified and defined, specifying e.g. the names of each component, and the
genes associated to these.
\item the distilled graph for the enrichment map, \code{distilled_em}, with the information
on the membership
\item the original \code{res_enrich}, augmented with the information of the membership
related to the meta-genesets
}
}
\description{
Distill the main topics from the enrichment results, based on the graph derived
from constructing an enrichment map
}
\examples{
library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)
res_enrich <- get_aggrscores(res_enrich, res_de, anno_df)

distilled <- distill_enrichment(res_enrich,
  res_de,
  annotation_obj,
  n_gs = 100,
  cluster_fun = "cluster_markov"
)
colnames(distilled$distilled_table)
distilled$distilled_em
}
