% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_shaker.R
\name{shake_gprofilerResult}
\alias{shake_gprofilerResult}
\title{Convert the output of g:Profiler}
\usage{
shake_gprofilerResult(gprofiler_output_file, gprofiler_output = NULL)
}
\arguments{
\item{gprofiler_output_file}{The location of the text file output, as exported from
g:Profiler}

\item{gprofiler_output}{A data.frame with the output of \code{gost()} in \code{gprofiler2}.
Usually it is one of the members of the list returned by the initial call to \code{gost}.}
}
\value{
A \code{data.frame} compatible for use in \code{\link[=GeneTonic]{GeneTonic()}} as \code{res_enrich}
}
\description{
Convert the output of g:Profiler for straightforward use in \code{\link[=GeneTonic]{GeneTonic()}}
}
\examples{
# degenes <- (mosdef::deresult_to_df(res_macrophage_IFNg_vs_naive, FDR = 0.01)$SYMBOL)
# if called directly withín R...
# enrichr_output_macrophage <- enrichr(degenes, dbs)
# or alternatively, if downloaded from the website in tabular format
gprofiler_output_file <- system.file(
  "extdata",
  "gProfiler_hsapiens_5-25-2020_tblexport_IFNg_vs_naive.csv",
  package = "GeneTonic"
)
res_from_gprofiler <- shake_gprofilerResult(gprofiler_output_file = gprofiler_output_file)

data(gostres_macrophage, package = "GeneTonic")
res_from_gprofiler_2 <- shake_gprofilerResult(
  gprofiler_output = gostres_macrophage$result
)
}
\seealso{
Other shakers: 
\code{\link{shake_davidResult}()},
\code{\link{shake_enrichResult}()},
\code{\link{shake_enrichrResult}()},
\code{\link{shake_fgseaResult}()},
\code{\link{shake_gsenrichResult}()},
\code{\link{shake_topGOtableResult}()}
}
\concept{shakers}
