% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_shaker.R
\name{shake_topGOtableResult}
\alias{shake_topGOtableResult}
\title{Convert a topGOtableResult object}
\usage{
shake_topGOtableResult(obj, p_value_column = "p.value_elim")
}
\arguments{
\item{obj}{A \code{topGOtableResult} object}

\item{p_value_column}{Character, specifying which column the p value for
enrichment has to be used. Example values are "p.value_elim" or "p.value_classic"}
}
\value{
A \code{data.frame} compatible for use in \code{\link[=GeneTonic]{GeneTonic()}} as \code{res_enrich}
}
\description{
Convert a topGOtableResult object for straightforward use in \code{\link[=GeneTonic]{GeneTonic()}}
}
\examples{

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")

res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)
}
\seealso{
Other shakers: 
\code{\link{shake_davidResult}()},
\code{\link{shake_enrichResult}()},
\code{\link{shake_enrichrResult}()},
\code{\link{shake_fgseaResult}()},
\code{\link{shake_gprofilerResult}()},
\code{\link{shake_gsenrichResult}()}
}
\concept{shakers}
