% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition-plots.R
\name{calcPartitionsRef}
\alias{calcPartitionsRef}
\title{Calculates the distribution of overlaps for a query set to a reference
assembly}
\usage{
calcPartitionsRef(query, refAssembly, bpProportion = FALSE)
}
\arguments{
\item{query}{A GenomicRanges or GenomicRangesList object with query regions}

\item{refAssembly}{A character vector specifying the reference genome
assembly (*e.g.* 'hg19'). This will be used to grab annotation
models with \code{getGeneModels}}

\item{bpProportion}{logical indicating if overlaps should be calculated
based on number of base pairs overlapping with each partition.
bpProportion=FALSE does overlaps in priority order,
bpProportion=TRUE counts number of overlapping
base pairs between query and each partition.}
}
\value{
A data.frame indicating the number of query region overlaps in
    several genomic partitions.
}
\description{
This function is a wrapper for \code{calcPartitions}
and \code{calcPartitionPercents} that uses built-in
partitions for a given reference genome assembly.
}
\examples{
calcPartitionsRef(vistaEnhancers, "hg19")
}
