% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichmentAnalysis.R
\name{enrichmentAnalysis}
\alias{enrichmentAnalysis}
\title{Gene ontology enrichment analysis}
\usage{
enrichmentAnalysis(
  node_regions,
  orgDb,
  onto = c("BP", "CC", "MF"),
  minGeneNum = 3,
  evidence = list(Experimental_evidence_codes = c("EXP", "IDA", "IPI", "IMP", "IGI",
    "IEP", "HTP", "HDA", "HMP", "HGI", "HEP"), `Phylogenetically-inferred_annotations` =
    c("IBA", "IBD", "IKR", "IRD"), Computational_analysis_evidence_codes = c("ISS",
    "ISO", "ISA", "ISM", "IGC", "RCA"), Author_statement_evidence_codes = c("TAS",
    "NAS"), Curator_statement_evidence_codes = c("IC", "ND"),
    Electronic_annotation_evidence_code = c("IEA")),
  ...
)
}
\arguments{
\item{node_regions}{GRanges object represent regions interacted with nodes.
The object must be annotated by \link{annotateNodes} 
with comp_id and gene_id in the metadata.}

\item{orgDb}{An object of \link[AnnotationDbi:AnnotationDb-class]{OrgDb}
to extract gene symbols.}

\item{onto}{Ontology category.}

\item{minGeneNum}{An integer(1) value indicating the minimal number of gene
to start the enrichment analysis. If total gene counts is smaller than
the `minGeneNum`, the NULL will be returned.}

\item{evidence}{The acceptable evidence code.}

\item{...}{Not used.}
}
\value{
A list with element enriched and enriched_in_compound.
Or NULL if total counts of gene is smaller than `minGeneNum`.
}
\description{
GO enrichment analysis for nodes
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene) ## for human hg19
library(org.Hs.eg.db) ## used to convert gene_id to gene_symbol 
library(GO.db)
set.seed(123)
node_regions <- createRandomNodes(TxDb.Hsapiens.UCSC.hg19.knownGene)
node_regions <- 
    annotateNodes(node_regions,
                  TxDb.Hsapiens.UCSC.hg19.knownGene,
                  org.Hs.eg.db)
enr <- enrichmentAnalysis(node_regions, org.Hs.eg.db, onto="BP")
}
